/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.core.LockResult;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.TokenBuilder;
import org.basex.util.options.Option;

public final class Info
extends AInfo {
    public Info() {
        super(false, new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        this.out.print(Info.info(this.context));
        return true;
    }

    @Override
    public void databases(LockResult lr) {
    }

    public static String info(Context context) {
        TokenBuilder tb = new TokenBuilder();
        tb.add(Text.GENERAL_INFO + ":" + Text.NL);
        Info.info(tb, Text.VERSINFO, Prop.VERSION);
        if (context.user.has(Perm.CREATE)) {
            Performance.gc(1);
            Info.info(tb, Text.USED_MEM, Performance.getMemory());
        }
        if (context.user.has(Perm.ADMIN)) {
            GlobalOptions gopts = context.globalopts;
            tb.add(Text.NL + Text.GLOBAL_OPTIONS + ":" + Text.NL);
            for (Option<?> o : gopts) {
                Info.info(tb, o.name(), gopts.get(o));
            }
        }
        MainOptions opts = context.options;
        tb.add(Text.NL + Text.LOCAL_OPTIONS + Text.NL);
        for (Option<?> o : opts) {
            Info.info(tb, o.name(), opts.get(o));
        }
        return tb.toString();
    }
}

