/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Store;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.atomic.AtomicUpdateCache;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.list.IntList;

public final class Replace
extends ACreate {
    public Replace(String path) {
        super(Perm.WRITE, true, path);
    }

    public Replace(String path, String input) {
        super(Perm.WRITE, true, path, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        String path;
        if (this.in == null) {
            IO io = IO.get(this.args[1]);
            if (!io.exists()) {
                return this.error(Text.RES_NOT_FOUND_X, io);
            }
            this.in = io.inputSource();
        }
        if ((path = MetaData.normPath(this.args[0])) == null || path.isEmpty()) {
            return this.error(Text.NO_DIR_ALLOWED_X, this.args[0]);
        }
        Data data = this.context.data();
        IntList pre = data.resources.docs(path, true);
        if (!data.startUpdate()) {
            return this.error(Text.DB_PINNED_X, data.meta.name);
        }
        try {
            boolean ok;
            IOFile file = data.meta.binary(path);
            if (file != null && file.exists()) {
                Store store = new Store(path);
                store.setInput(this.in);
                ok = store.run(this.context) || this.error(store.info(), new Object[0]);
            } else {
                Add add = new Add(path);
                add.setInput(this.in);
                add.lock = false;
                boolean bl = ok = add.run(this.context) || this.error(add.info(), new Object[0]);
                if (ok) {
                    AtomicUpdateCache atomics = new AtomicUpdateCache(data);
                    int ps = pre.size();
                    for (int p = 0; p < ps; ++p) {
                        atomics.addDelete(pre.get(p));
                    }
                    atomics.execute(false);
                }
            }
            boolean bl = ok && this.info(Text.RES_REPLACED_X_X, 1, this.perf);
            return bl;
        }
        finally {
            data.finishUpdate();
        }
    }
}

