/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.LockResult;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public class Restore
extends ABackup {
    private boolean closed;

    public Restore(String arg) {
        super(arg);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!Databases.validName(name)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList backups = this.context.databases.backups(name);
        if (backups.isEmpty()) {
            return this.error(Text.BACKUP_NOT_FOUND_X, name);
        }
        String backup = backups.get(0);
        String db = Databases.name(backup);
        if (!this.closed) {
            this.closed = Restore.close(this.context, db);
        }
        if (this.context.pinned(db)) {
            return this.error(Text.DB_PINNED_X, db);
        }
        try {
            Restore.restore(db, backup, this, this.context);
            return !this.closed || new Open(db).run(this.context) ? this.info(Text.DB_RESTORED_X, backup, this.perf) : this.error(Text.DB_NOT_RESTORED_X, db);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(Text.DB_NOT_RESTORED_X, db);
        }
    }

    @Override
    public void databases(LockResult lr) {
        super.databases(lr);
        String backup = this.args[0];
        lr.write.add(backup).add(Databases.name(backup));
    }

    public static void restore(String db, String backup, Restore cmd, Context context) throws IOException {
        DropDB.drop(db, context);
        IOFile dbpath = context.globalopts.dbpath();
        Zip zip = new Zip(new IOFile(dbpath, backup + ".zip"));
        if (cmd != null) {
            cmd.proc(zip);
        }
        zip.unzip(dbpath);
    }

    @Override
    protected String tit() {
        return Text.RESTORE;
    }

    @Override
    public boolean newData(Context ctx) {
        this.closed = Restore.close(ctx, this.args[0]);
        return this.closed;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }
}

