/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.basex.core.Text;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIMacOSX;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXImages;
import org.basex.util.Prop;

public final class GUIConstants {
    public static final String MAPVIEW = "map";
    public static final String FOLDERVIEW = "folder";
    public static final String TEXTVIEW = "text";
    public static final String TABLEVIEW = "table";
    public static final String INFOVIEW = "info";
    public static final String EXPLOREVIEW = "explore";
    public static final String PLOTVIEW = "plot";
    public static final String TREEVIEW = "tree";
    public static final String EDITORVIEW = "editor";
    public static final String VIEWS = "V H editor folder map plot  - H text info table tree explore - -";
    static final GUIMenuCmd[] TOOLBAR = new GUIMenuCmd[]{GUIMenuCmd.C_CREATE, GUIMenuCmd.C_OPEN_MANAGE, GUIMenuCmd.C_INFO, GUIMenuCmd.C_CLOSE, null, GUIMenuCmd.C_GOHOME, GUIMenuCmd.C_GOBACK, GUIMenuCmd.C_GOUP, GUIMenuCmd.C_GOFORWARD, null, GUIMenuCmd.C_SHOWEDITOR, GUIMenuCmd.C_SHOWRESULT, GUIMenuCmd.C_SHOWINFO, null, GUIMenuCmd.C_SHOWMAP, GUIMenuCmd.C_SHOWTREE, GUIMenuCmd.C_SHOWFOLDER, GUIMenuCmd.C_SHOWPLOT, GUIMenuCmd.C_SHOWTABLE, GUIMenuCmd.C_SHOWEXPLORE};
    static final String[] MENUBAR = new String[]{Text.DATABASE, Text.EDITOR, Text.VIEW, Text.VISUALIZATION, Text.OPTIONS, Text.HELP};
    static final GUICommand[][] MENUITEMS = new GUICommand[][]{{GUIMenuCmd.C_CREATE, GUIMenuCmd.C_OPEN_MANAGE, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_INFO, GUIMenuCmd.C_EXPORT, GUIMenuCmd.C_CLOSE, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_SERVER, Prop.MAC ? null : GUIMenuCmd.SEPARATOR, Prop.MAC ? null : GUIMenuCmd.C_EXIT}, {GUIMenuCmd.C_EDITNEW, GUIMenuCmd.C_EDITOPEN, GUIMenuCmd.C_EDITREOPEN, GUIMenuCmd.C_EDITSAVE, GUIMenuCmd.C_EDITSAVEAS, GUIMenuCmd.C_EDITCLOSE, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_FORMAT, GUIMenuCmd.C_COMMENT, GUIMenuCmd.C_SORT, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_NEXTERROR, GUIMenuCmd.C_JUMPFILE}, {GUIMenuCmd.C_SHOWEDITOR, GUIMenuCmd.C_SHOWPROJECT, GUIMenuCmd.C_FILESEARCH, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_SHOWRESULT, GUIMenuCmd.C_SHOWINFO, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_SHOWBUTTONS, GUIMenuCmd.C_SHOWINPUT, GUIMenuCmd.C_SHOWSTATUS, GUIMacOSX.nativeFullscreen() ? null : GUIMenuCmd.C_FULL}, {GUIMenuCmd.C_SHOWMAP, GUIMenuCmd.C_SHOWTREE, GUIMenuCmd.C_SHOWFOLDER, GUIMenuCmd.C_SHOWPLOT, GUIMenuCmd.C_SHOWTABLE, GUIMenuCmd.C_SHOWEXPLORE}, {GUIMenuCmd.C_RTEXEC, GUIMenuCmd.C_RTFILTER, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_COLOR, GUIMenuCmd.C_FONTS, Prop.MAC ? null : GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_PACKAGES, Prop.MAC ? null : GUIMenuCmd.C_PREFS}, {GUIMenuCmd.C_HELP, Prop.MAC ? null : GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_COMMUNITY, GUIMenuCmd.C_UPDATES, Prop.MAC ? null : GUIMenuCmd.SEPARATOR, Prop.MAC ? null : GUIMenuCmd.C_ABOUT}};
    public static final GUIMenuCmd[] POPUP = new GUIMenuCmd[]{GUIMenuCmd.C_GOBACK, GUIMenuCmd.C_FILTER, null, GUIMenuCmd.C_COPY, GUIMenuCmd.C_PASTE, GUIMenuCmd.C_DELETE, GUIMenuCmd.C_INSERT, GUIMenuCmd.C_EDIT, null, GUIMenuCmd.C_COPYPATH};
    public static final Cursor CURSORARROW = new Cursor(0);
    public static final Cursor CURSORHAND = new Cursor(12);
    public static final Cursor CURSORWAIT = new Cursor(3);
    public static final Cursor CURSORMOVEH = new Cursor(11);
    public static final Cursor CURSORMOVEV = new Cursor(8);
    public static final Cursor CURSORTEXT = new Cursor(2);
    public static final Cursor CURSORMOVE = new Cursor(13);
    public static final Color LGRAY = new Color(224, 224, 224);
    public static final Color GRAY = new Color(160, 160, 160);
    public static final Color DGRAY = new Color(64, 64, 64);
    public static final Color RED = new Color(208, 0, 0);
    public static final Color LRED = new Color(255, 216, 216);
    public static final Color GREEN = new Color(0, 176, 0);
    public static final Color BLUE = new Color(0, 64, 192);
    public static Color color1;
    public static Color color2;
    public static Color color3;
    public static Color color4;
    public static Color colormark1;
    public static Color colormark2;
    public static Color colormark3;
    public static Color colormark4;
    public static Color color1A;
    public static Color color2A;
    public static Color color3A;
    public static Color color4A;
    public static Color colormark1A;
    public static Color colormark2A;
    private static final Color[] COLORS;
    private static final Font TFONT;
    public static Font lfont;
    public static Font font;
    public static Font bfont;
    public static Font mfont;
    public static Font dmfont;
    public static int fontSize;
    private static int[] dwidth;
    private static int[] lwidth;
    private static int[] fwidth;
    private static int[] bwidth;
    public static int[] mfwidth;
    public static final int SHIFT = 1;
    public static final int ALT = 8;
    public static final int CTRL = 2;
    public static final int META;

    private GUIConstants() {
    }

    public static void init(GUIOptions opts) {
        int r = opts.get(GUIOptions.COLORRED);
        int g = opts.get(GUIOptions.COLORGREEN);
        int b = opts.get(GUIOptions.COLORBLUE);
        color1 = new Color(GUIConstants.col(r, 24), GUIConstants.col(g, 25), GUIConstants.col(b, 40));
        color2 = new Color(GUIConstants.col(r, 32), GUIConstants.col(g, 32), GUIConstants.col(b, 44));
        color3 = new Color(GUIConstants.col(r, 48), GUIConstants.col(g, 50), GUIConstants.col(b, 40));
        color4 = new Color(GUIConstants.col(r, 140), GUIConstants.col(g, 100), GUIConstants.col(b, 70));
        color1A = new Color(GUIConstants.col(r, 110), GUIConstants.col(g, 150), GUIConstants.col(b, 160), 100);
        colormark1A = new Color(GUIConstants.col(r, 32), GUIConstants.col(g, 160), GUIConstants.col(b, 320), 100);
        colormark2A = new Color(GUIConstants.col(r, 12), GUIConstants.col(g, 60), GUIConstants.col(b, 120), 100);
        colormark1 = new Color(GUIConstants.col(r, 16), GUIConstants.col(g, 120), GUIConstants.col(b, 240));
        colormark2 = new Color(GUIConstants.col(r, 16), GUIConstants.col(g, 80), GUIConstants.col(b, 160));
        colormark3 = new Color(GUIConstants.col(r, 32), GUIConstants.col(g, 160), GUIConstants.col(b, 320));
        colormark4 = new Color(GUIConstants.col(r, 1), GUIConstants.col(g, 40), GUIConstants.col(b, 80));
        for (int l = 1; l < COLORS.length + 1; ++l) {
            GUIConstants.COLORS[l - 1] = new Color(Math.max(255 - l * r, 0), Math.max(255 - l * g, 0), Math.max(255 - l * b, 0));
        }
        Color c = COLORS[16];
        color2A = new Color(c.getRed(), c.getGreen(), c.getBlue(), 40);
        color3A = new Color(c.getRed(), c.getGreen(), c.getBlue(), 100);
        color4A = new Color(c.getRed(), c.getGreen(), c.getBlue(), 20);
        String f = opts.get(GUIOptions.FONT);
        int type = opts.get(GUIOptions.FONTTYPE);
        fontSize = opts.get(GUIOptions.FONTSIZE);
        font = new Font(f, type, fontSize);
        mfont = new Font(opts.get(GUIOptions.MONOFONT), type, fontSize);
        bfont = new Font(f, 1, fontSize);
        lfont = new Font(f, type, 18 + (fontSize >> 1));
        dmfont = new Font(opts.get(GUIOptions.MONOFONT), 0, TFONT.getSize() - 1);
        Container comp = new Container();
        dwidth = comp.getFontMetrics(dmfont).getWidths();
        fwidth = comp.getFontMetrics(font).getWidths();
        lwidth = comp.getFontMetrics(lfont).getWidths();
        mfwidth = comp.getFontMetrics(mfont).getWidths();
        bwidth = comp.getFontMetrics(bfont).getWidths();
    }

    public static Color color(int i) {
        return COLORS[Math.min(COLORS.length - 1, i)];
    }

    public static int[] fontWidths(Font f) {
        if (f == font) {
            return fwidth;
        }
        if (f == mfont) {
            return mfwidth;
        }
        if (f == bfont) {
            return bwidth;
        }
        if (f == lfont) {
            return lwidth;
        }
        if (f == dmfont) {
            return dwidth;
        }
        return new Container().getFontMetrics(f).getWidths();
    }

    private static int col(int c, int f) {
        return Math.max(0, 255 - c * f / 10);
    }

    static {
        COLORS = new Color[100];
        TFONT = UIManager.getFont("TextArea.font");
        META = Prop.MAC ? 4 : 2;
    }

    public static enum Fill {
        PLAIN,
        NONE,
        GRADIENT;

    }

    public static enum Msg {
        WARN("warn", "warning"),
        ERROR("error", "error"),
        SUCCESS("ok", "information"),
        QUESTION("warn", "question"),
        YESNOCANCEL("warn", "question");

        public final Icon small;
        public final Icon large;

        private Msg(String s, String l) {
            this.small = BaseXImages.icon(s);
            this.large = UIManager.getIcon("OptionPane." + l + "Icon");
        }
    }
}

