/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import org.basex.build.JsonOptions;
import org.basex.build.JsonParser;
import org.basex.build.JsonParserOptions;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.dialog.DialogExport;
import org.basex.gui.dialog.DialogParser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.TextPanel;
import org.basex.io.IOContent;
import org.basex.query.value.node.DBNode;
import org.basex.util.list.StringList;

final class DialogJsonParser
extends DialogParser {
    private static final String EXAMPLE = "{ \"Person\": \"John\\nAdam\",\n  \"Born\"  : 1984,\n  \"X?_\"  : [ true, null ] }";
    private static final String EXAMPLEML = "[ \"Person\",\n  { \"born\": \"1984\" },\n  \"John\\nAdam\"\n]";
    private final JsonParserOptions jopts;
    private final TextPanel example;
    private final BaseXCombo encoding;
    private final BaseXCombo format;
    private final BaseXCheckBox unescape;
    private final BaseXCheckBox lax;
    private final BaseXCheckBox merge;
    private final BaseXCheckBox strings;
    private final BaseXCombo spec;

    DialogJsonParser(BaseXDialog d, MainOptions opts) {
        super(d);
        this.jopts = opts.get(MainOptions.JSONPARSER);
        this.encoding = DialogExport.encoding(d, this.jopts.get(JsonParserOptions.ENCODING));
        StringList sl = new StringList();
        JsonOptions.JsonFormat[] formats = JsonOptions.JsonFormat.values();
        int fl = formats.length - 1;
        for (int f = 0; f < fl; ++f) {
            sl.add(formats[f].toString());
        }
        this.format = new BaseXCombo((Window)d, sl.toArray());
        this.format.setSelectedItem((Object)this.jopts.get(JsonOptions.FORMAT));
        sl.reset();
        for (JsonOptions.JsonSpec cs : JsonOptions.JsonSpec.values()) {
            sl.add(cs.toString());
        }
        this.spec = new BaseXCombo((Window)d, sl.toArray());
        this.spec.setSelectedItem((Object)this.jopts.get(JsonOptions.SPEC));
        this.unescape = new BaseXCheckBox(Text.UNESCAPE_CHARS, JsonParserOptions.UNESCAPE, this.jopts, d);
        this.merge = new BaseXCheckBox(Text.MERGE_TYPES, JsonOptions.MERGE, this.jopts, d);
        this.strings = new BaseXCheckBox(Text.INCLUDE_STRINGS, JsonOptions.STRINGS, this.jopts, d);
        this.lax = new BaseXCheckBox(Text.LAX_NAME_CONVERSION, JsonOptions.LAX, this.jopts, d);
        BaseXBack pp = new BaseXBack(new TableLayout(2, 1, 0, 8));
        BaseXBack p = new BaseXBack(new TableLayout(3, 2, 8, 4));
        p.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        p.add(this.encoding);
        p.add(new BaseXLabel(Text.FORMAT + ":", true, true));
        p.add(this.format);
        p.add(new BaseXLabel(Text.SPECIFICATION + ":", true, true));
        p.add(this.spec);
        pp.add(p);
        p = new BaseXBack(new TableLayout(4, 1));
        p.add(this.unescape);
        p.add(this.merge);
        p.add(this.strings);
        p.add(this.lax);
        pp.add(p);
        this.add((Component)pp, "West");
        this.example = new TextPanel(false, d);
        this.add((Component)this.example, "Center");
        this.action(true);
    }

    @Override
    boolean action(boolean active) {
        try {
            JsonOptions.JsonSpec js = this.jopts.get(JsonOptions.SPEC);
            JsonOptions.JsonFormat jf = this.jopts.get(JsonOptions.FORMAT);
            this.lax.setEnabled(jf == JsonOptions.JsonFormat.DIRECT);
            this.merge.setEnabled(jf != JsonOptions.JsonFormat.JSONML);
            this.strings.setEnabled(jf != JsonOptions.JsonFormat.JSONML);
            if (active) {
                String json = jf == JsonOptions.JsonFormat.JSONML ? EXAMPLEML : (js == JsonOptions.JsonSpec.LIBERAL ? EXAMPLE.replace("\"Person\"", "Person").replace(" }", ", }") : (js == JsonOptions.JsonSpec.ECMA_262 ? "\"John\\nMiller\"" : EXAMPLE));
                IOContent io = JsonParser.toXML(new IOContent(json), this.jopts);
                DBNode node = new DBNode(io, this.dialog.gui.context.options);
                this.example.setText(DialogJsonParser.example(MainOptions.MainParser.JSON.name(), json, node.serialize().toString()));
            }
        }
        catch (IOException ex) {
            this.example.setText(DialogJsonParser.error(ex));
        }
        return true;
    }

    @Override
    void update() {
        String enc = this.encoding.getSelectedItem();
        this.jopts.set(JsonParserOptions.ENCODING, enc.equals("UTF-8") ? null : enc);
        this.jopts.set(JsonParserOptions.UNESCAPE, this.unescape.isSelected());
        this.jopts.set(JsonOptions.MERGE, this.merge.isSelected());
        this.jopts.set(JsonOptions.STRINGS, this.strings.isSelected());
        this.jopts.set(JsonOptions.FORMAT, this.format.getSelectedItem());
        this.jopts.set(JsonOptions.SPEC, this.spec.getSelectedItem());
        this.jopts.set(JsonOptions.LAX, this.lax.isSelected());
    }

    @Override
    void setOptions(GUI gui) {
        gui.set(MainOptions.JSONPARSER, this.jopts);
    }
}

