/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;

public final class BaseXSlider
extends BaseXPanel {
    private static final int DWIDTH = 120;
    private static final double SLIDERW = 20.0;
    private final BaseXDialog dialog;
    private final int min;
    private final int max;
    private Options options;
    private NumberOption option;
    private int value;
    private int oldValue = -1;
    private int mouseX;

    public BaseXSlider(int mn, int mx, NumberOption opt, Options opts, Window win) {
        this(mn, mx, opts.get(opt), win);
        this.options = opts;
        this.option = opt;
    }

    public BaseXSlider(int mn, int mx, int i, Window w) {
        super(w);
        this.min = mn;
        this.max = mx;
        this.value = i;
        this.dialog = w instanceof BaseXDialog ? (BaseXDialog)w : null;
        this.mode(GUIConstants.Fill.NONE).setFocusable(true);
        this.setPreferredSize(new Dimension(120, this.getFont().getSize() + 3));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseXSlider.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BaseXSlider.this.repaint();
            }
        });
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int v) {
        this.value = v;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        int hh = h / 2;
        g.setColor(this.hasFocus() ? Color.white : GUIConstants.LGRAY);
        g.fillRect(0, hh - 3, w, 4);
        g.setColor(Color.black);
        g.drawLine(0, hh - 3, w, hh - 3);
        g.drawLine(0, hh - 3, 0, hh + 2);
        g.setColor(GUIConstants.GRAY);
        g.drawLine(w - 1, hh - 3, w - 1, hh + 2);
        g.drawLine(0, hh + 2, w, hh + 2);
        double x = (double)(this.value - this.min) * ((double)w - 20.0) / (double)(this.max - this.min);
        BaseXLayout.drawCell(g, (int)x, (int)(x + 20.0), hh - 6, hh + 6, this.oldValue != -1);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        this.mouseX = e.getX();
        double w = (double)this.getWidth() - 20.0;
        double r = this.max - this.min;
        double x = (double)(this.value - this.min) * w / r;
        if ((double)this.mouseX < x || (double)this.mouseX >= x + 20.0) {
            this.value = (int)((double)this.mouseX * r / w + (double)this.min);
        }
        this.oldValue = this.value;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.oldValue = -1;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double prop = (double)((this.max - this.min) * (this.mouseX - e.getX())) / ((double)this.getWidth() - 20.0);
        int old = this.value;
        this.value = Math.max(this.min, Math.min(this.max, (int)((double)this.oldValue - prop)));
        if (this.value != old) {
            if (this.dialog != null) {
                this.dialog.action(null);
            }
            for (ActionListener al : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
                al.actionPerformed(null);
            }
            this.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int old = this.value;
        if (BaseXKeys.PREVCHAR.is(e) || BaseXKeys.PREVLINE.is(e)) {
            this.value = Math.max(this.min, this.value - 1);
        } else if (BaseXKeys.NEXTCHAR.is(e) || BaseXKeys.NEXTLINE.is(e)) {
            this.value = Math.min(this.max, this.value + 1);
        } else if (BaseXKeys.NEXTPAGE.is(e)) {
            this.value = Math.max(this.min, this.value + 10);
        } else if (BaseXKeys.PREVPAGE.is(e)) {
            this.value = Math.min(this.max, this.value - 10);
        } else if (BaseXKeys.LINESTART.is(e)) {
            this.value = this.min;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.value = this.max;
        }
        if (this.value != old) {
            if (this.dialog != null) {
                this.dialog.action(null);
            }
            for (ActionListener al : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
                al.actionPerformed(null);
            }
            this.repaint();
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void assign() {
        this.options.set(this.option, this.value);
    }
}

