/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXSplit;

final class BaseXSplitSep
extends BaseXBack {
    static final int SIZE = 8;
    private final Color fore;
    private final Color back;
    private final boolean l;

    BaseXSplitSep(boolean lay) {
        this.setCursor(lay ? GUIConstants.CURSORMOVEH : GUIConstants.CURSORMOVEV);
        this.fore = this.getBackground();
        this.back = this.fore.darker();
        MouseInputAdapter mouse = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((BaseXSplit)BaseXSplitSep.this.getParent()).startDrag(BaseXSplitSep.this.pos(e));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ((BaseXSplit)BaseXSplitSep.this.getParent()).drag(BaseXSplitSep.this, BaseXSplitSep.this.pos(e));
            }
        };
        this.addMouseListener(mouse);
        this.addMouseMotionListener(mouse);
        this.l = lay;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.fore);
        g.fillRect(0, 0, w, h);
        g.setColor(this.back);
        g.drawLine(0, 0, this.l ? 0 : w, this.l ? h : 0);
        g.drawLine(this.l ? w - 1 : 0, this.l ? 0 : h - 1, this.l ? w - 1 : w, this.l ? h : h - 1);
    }

    private double pos(MouseEvent e) {
        Point p = this.getLocationOnScreen();
        return this.l ? (double)(p.x + e.getX()) : (double)(p.y + e.getY());
    }
}

