/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JTabbedPane;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXLayout;

public final class BaseXTabs
extends JTabbedPane {
    private int draggedTab = -1;

    public BaseXTabs(Window win) {
        BaseXLayout.addInteraction(this, win);
    }

    public void add(Component content, Component header, int index) {
        this.add(content, index);
        this.setSelectedComponent(content);
        this.setTabComponentAt(this.getSelectedIndex(), header);
    }

    public void addDragDrop(final boolean last) {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (BaseXTabs.this.draggedTab == -1) {
                    int t = BaseXTabs.this.getUI().tabForCoordinate(BaseXTabs.this, e.getX(), e.getY());
                    int tabs = BaseXTabs.this.getTabCount();
                    if (tabs == (last ? 1 : 2) || !last && t + 1 == tabs) {
                        t = -1;
                    }
                    if (t != -1) {
                        BaseXTabs.this.draggedTab = t;
                        BaseXTabs.this.setCursor(GUIConstants.CURSORMOVE);
                    }
                } else {
                    BaseXTabs.this.drop(last, e);
                }
                BaseXTabs.this.refreshTabs();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (BaseXTabs.this.draggedTab < 0) {
                    return;
                }
                BaseXTabs.this.drop(last, e);
                BaseXTabs.this.draggedTab = -1;
                BaseXTabs.this.setCursor(GUIConstants.CURSORARROW);
                BaseXTabs.this.refreshTabs();
            }
        });
    }

    private void drop(boolean last, MouseEvent e) {
        int newTab = Math.min(this.getTabCount() - (last ? 1 : 2), this.getUI().tabForCoordinate(this, e.getX(), e.getY()));
        if (newTab >= 0 && newTab != this.draggedTab) {
            Component comp = this.getComponentAt(this.draggedTab);
            Component head = this.getTabComponentAt(this.draggedTab);
            this.removeTabAt(this.draggedTab);
            this.add(comp, head, newTab);
            this.draggedTab = newTab;
        }
    }

    private void refreshTabs() {
        int tabs = this.getTabCount();
        for (int t = 0; t < tabs; ++t) {
            Component tab = this.getTabComponentAt(t);
            if (!(tab instanceof Container)) continue;
            Container cont = (Container)tab;
            int comps = cont.getComponentCount();
            for (int c = 0; c < comps; ++c) {
                cont.getComponent(c).setEnabled(this.draggedTab == -1 || t == this.draggedTab);
            }
        }
    }
}

