/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import org.basex.gui.text.TextEditor;
import org.basex.util.Token;
import org.basex.util.list.IntList;

final class TextIterator {
    private final byte[] text;
    private final int length;
    private final int caret;
    private final int start;
    private final int end;
    private final int errPos;
    private final IntList[] searchPos;
    private int pos;
    private int posEnd;
    private int searchIndex;
    private boolean link;

    TextIterator(TextEditor et) {
        this.text = et.text();
        this.length = this.text.length;
        this.caret = et.pos();
        this.start = et.start;
        this.end = et.end;
        this.errPos = et.error;
        this.searchPos = et.searchPos;
    }

    boolean moreTokens() {
        int p;
        this.pos = p = this.posEnd;
        if (p >= this.length) {
            return false;
        }
        int ch = Token.cp(this.text, p);
        p += Token.cl(this.text, p);
        if (Token.ftChar(ch)) {
            while (p < this.length && Token.ftChar(ch = Token.cp(this.text, p))) {
                p += Token.cl(this.text, p);
            }
        }
        this.posEnd = p;
        return true;
    }

    String nextString() {
        return this.posEnd <= this.length ? Token.string(this.text, this.pos, this.posEnd - this.pos) : "";
    }

    boolean caretLine(boolean first) {
        for (int p = this.pos + (first ? 0 : 1); p < this.length; ++p) {
            if (p == this.caret) {
                return true;
            }
            if (this.text[p] != 10) continue;
            return false;
        }
        return this.caret == this.length;
    }

    int curr() {
        return Token.cp(this.text, this.pos);
    }

    int pos() {
        return this.pos;
    }

    void pos(int p) {
        this.pos = p;
    }

    boolean more() {
        return this.pos < this.posEnd;
    }

    int next() {
        int c = this.curr();
        this.pos += Token.cl(this.text, this.pos);
        return c;
    }

    boolean edited() {
        return this.caret >= this.pos && this.caret < this.posEnd;
    }

    int caret() {
        return this.caret;
    }

    boolean selectStart() {
        return this.start != this.end && (this.inSelect() || (this.start < this.end ? this.start >= this.pos && this.start < this.posEnd : this.end >= this.pos && this.end < this.posEnd));
    }

    boolean inSelect() {
        return this.start < this.end ? this.pos >= this.start && this.pos < this.end : this.pos >= this.end && this.pos < this.start;
    }

    boolean searchStart() {
        if (this.searchPos == null) {
            return false;
        }
        if (this.searchIndex == this.searchPos[0].size()) {
            return false;
        }
        while (this.pos > this.searchPos[1].get(this.searchIndex)) {
            if (++this.searchIndex != this.searchPos[0].size()) continue;
            return false;
        }
        return this.posEnd > this.searchPos[0].get(this.searchIndex);
    }

    boolean inSearch() {
        boolean in;
        if (this.searchIndex >= this.searchPos[0].size() || this.pos < this.searchPos[0].get(this.searchIndex)) {
            return false;
        }
        boolean bl = in = this.pos < this.searchPos[1].get(this.searchIndex);
        if (!in) {
            ++this.searchIndex;
        }
        return in;
    }

    boolean erroneous() {
        return this.errPos >= this.pos && this.errPos < this.posEnd;
    }

    int error() {
        return this.errPos;
    }

    void link(boolean lnk) {
        this.link = lnk;
    }

    String link() {
        int ls;
        if (!this.link) {
            return null;
        }
        int le = ls = this.pos;
        while (ls > 0 && this.text[ls - 1] != 5) {
            --ls;
        }
        while (le < this.length && this.text[le] != 5) {
            ++le;
        }
        return Token.string(this.text, ls, le - ls);
    }
}

