/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import org.basex.core.Text;
import org.basex.gui.AGUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewAlignment;
import org.basex.gui.view.ViewLayout;
import org.basex.gui.view.ViewPanel;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;

public final class ViewContainer
extends BaseXBack {
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private final AGUI gui;
    private ViewAlignment layout;
    private String layoutString;
    private final ViewPanel[] views;
    private ViewPanel source;
    private ViewPanel target;
    private final Image logo;
    private Target orient;
    private Point sp;
    private final int[] pos = new int[4];

    public ViewContainer(AGUI main, View ... v) {
        this.layout(new BorderLayout()).mode(GUIConstants.Fill.PLAIN);
        this.logo = BaseXImages.get("logo");
        this.setBackground(Color.white);
        this.views = new ViewPanel[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.views[i] = new ViewPanel(v[i]);
        }
        this.gui = main;
        if (!this.buildLayout(this.gui.gopts.get(GUIOptions.VIEWS)) && !this.buildLayout("V H editor folder map plot  - H text info table tree explore - -")) {
            Util.errln(Util.className(this) + ": could not build layout \"%\"", "V H editor folder map plot  - H text info table tree explore - -");
        }
    }

    public void updateViews() {
        this.layout.setVisibility(this.gui.context.data() != null);
        String ls = this.layout.layoutString(false);
        if (ls.equals(this.layoutString)) {
            return;
        }
        this.removeAll();
        this.layout.createView(this);
        this.validate();
        this.repaint();
        this.gui.gopts.set(GUIOptions.VIEWS, this.layout.layoutString(true));
        this.layoutString = ls;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getComponentCount() != 0) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int hh = Math.max(220, Math.min(700, h));
        Insets i = this.getInsets();
        if (this.gui.gopts.get(GUIOptions.GRADIENT).booleanValue()) {
            BaseXLayout.fill(g, Color.white, GUIConstants.color1, i.left, i.top, w - i.right, h - i.bottom);
        }
        if (w < 150 || h < 160) {
            return;
        }
        int lh = this.logo.getHeight(this);
        int y = (hh - lh - 60) / 2;
        g.drawImage(this.logo, (w - this.logo.getWidth(this)) / 2, y, this);
        if (w < 200 || h < 200) {
            return;
        }
        g.setColor(GUIConstants.DGRAY);
        g.setFont(GUIConstants.lfont);
        BaseXLayout.drawCenter(g, Text.VERSINFO + ' ' + Prop.VERSION, w, y + 20 + lh);
    }

    void dragPanel(ViewPanel panel, Point p) {
        this.source = panel;
        this.sp = p;
        this.calc();
        this.repaint();
    }

    void dropPanel() {
        if (this.source == null) {
            return;
        }
        if (this.orient != null) {
            if (this.layout.delete(this.source) && !(this.layout.comp[0] instanceof ViewPanel)) {
                this.layout = (ViewAlignment)this.layout.comp[0];
            }
            if (this.target == null) {
                this.layout = this.addView(this.layout);
            } else {
                this.add(this.layout);
            }
            this.updateViews();
        }
        this.source = null;
        this.repaint();
    }

    private boolean add(ViewAlignment lay) {
        for (int o = 0; o < lay.comp.length; ++o) {
            boolean east;
            ViewLayout comp = lay.comp[o];
            if (comp instanceof ViewAlignment) {
                if (!this.add((ViewAlignment)comp)) continue;
                return true;
            }
            if (comp != this.target) continue;
            boolean west = this.orient == Target.WEST;
            boolean bl = east = this.orient == Target.EAST;
            if (this.orient == Target.NORTH || west) {
                if (lay.horiz == west) {
                    lay.add(this.source, o);
                } else {
                    ViewAlignment l = new ViewAlignment(west);
                    l.add(this.source);
                    l.add(this.target);
                    lay.comp[o] = l;
                }
            } else if (this.orient == Target.SOUTH || east) {
                if (lay.horiz == east) {
                    lay.add(this.source, o + 1);
                } else {
                    ViewAlignment l = new ViewAlignment(east);
                    l.add(this.target);
                    l.add(this.source);
                    lay.comp[o] = l;
                }
            }
            return true;
        }
        return false;
    }

    private ViewAlignment addView(ViewAlignment lay) {
        boolean west = this.orient == Target.WEST;
        boolean east = this.orient == Target.EAST;
        ViewAlignment l = lay;
        if (this.orient == Target.NORTH || west) {
            if (l.horiz == west) {
                l.add(this.source, 0);
            } else {
                ViewAlignment ll = new ViewAlignment(west);
                ll.add(this.source);
                ll.add(l);
                l = ll;
            }
        } else if (this.orient == Target.SOUTH || east) {
            if (l.horiz == east) {
                l.add(this.source);
            } else {
                ViewAlignment ll = new ViewAlignment(east);
                ll.add(l);
                ll.add(this.source);
                l = ll;
            }
        }
        return l;
    }

    private ViewPanel getTarget() {
        for (ViewPanel v : this.views) {
            if (!v.isVisible() || !new Rectangle(this.absLoc(v), v.getSize()).contains(this.sp)) continue;
            return v;
        }
        return null;
    }

    private Point absLoc(Component comp) {
        Component c = comp;
        Point p = c.getLocation();
        do {
            c = c.getParent();
            p.x += c.getX();
            p.y += c.getY();
        } while (c.getParent() != this);
        return p;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.source == null) {
            return;
        }
        ((Graphics2D)g).setStroke(STROKE);
        if (this.orient != null) {
            g.setColor(GUIConstants.color(16));
            g.drawRect(this.pos[0], this.pos[1], this.pos[2] - 1, this.pos[3] - 1);
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.3f));
            g.setColor(GUIConstants.color(8));
            g.fillRect(this.pos[0], this.pos[1], this.pos[2], this.pos[3]);
        }
    }

    private void calc() {
        int hh = this.getHeight();
        int ww = this.getWidth();
        this.pos[0] = 1;
        this.pos[1] = 1;
        this.pos[2] = ww - 2;
        this.pos[3] = hh - 2;
        this.orient = null;
        this.target = this.getTarget();
        if (this.target != null && this.target != this.source) {
            Rectangle tr = new Rectangle(this.absLoc(this.target), this.target.getSize());
            int minx = tr.width >> 1;
            int miny = tr.height >> 1;
            if (Math.abs(tr.x + tr.width / 2 - this.sp.x) < tr.width / 3) {
                if (this.sp.y > tr.y && this.sp.y < tr.y + miny) {
                    this.pos[0] = tr.x;
                    this.pos[1] = tr.y;
                    this.pos[2] = tr.width;
                    this.pos[3] = miny;
                    this.orient = Target.NORTH;
                } else if (this.sp.y > tr.y + tr.height - miny && this.sp.y < tr.y + tr.height) {
                    this.pos[0] = tr.x;
                    this.pos[1] = tr.y + tr.height - miny;
                    this.pos[2] = tr.width;
                    this.pos[3] = miny;
                    this.orient = Target.SOUTH;
                }
            } else if (Math.abs(tr.y + tr.height / 2 - this.sp.y) < tr.height / 3) {
                if (this.sp.x > tr.x && this.sp.x < tr.x + minx) {
                    this.pos[0] = tr.x;
                    this.pos[1] = tr.y;
                    this.pos[2] = minx;
                    this.pos[3] = tr.height;
                    this.orient = Target.WEST;
                } else if (this.sp.x > tr.x + tr.width - minx && this.sp.x < tr.x + tr.width) {
                    this.pos[0] = tr.x + tr.width - minx;
                    this.pos[1] = tr.y;
                    this.pos[2] = minx;
                    this.pos[3] = tr.height;
                    this.orient = Target.EAST;
                }
            }
        }
        if (this.orient == null) {
            int minx = ww >> 2;
            int miny = hh >> 2;
            this.target = null;
            if (this.sp.y < miny) {
                this.pos[3] = miny;
                this.orient = Target.NORTH;
            } else if (this.sp.y > hh - miny) {
                this.pos[3] = miny;
                this.pos[1] = hh - miny;
                this.orient = Target.SOUTH;
            } else if (this.sp.x < minx) {
                this.pos[2] = minx;
                this.orient = Target.WEST;
            } else if (this.sp.x > ww - minx) {
                this.pos[2] = minx;
                this.pos[0] = ww - minx;
                this.orient = Target.EAST;
            }
        }
    }

    private boolean buildLayout(String cnstr) {
        try {
            this.layout = null;
            int lvl = -1;
            ViewAlignment[] l = new ViewAlignment[16];
            StringTokenizer st = new StringTokenizer(cnstr);
            int nv = 0;
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (Token.eq(t, "H", "V")) {
                    l[lvl + 1] = new ViewAlignment("H".equals(t));
                    if (this.layout == null) {
                        this.layout = l[0];
                    } else {
                        l[lvl].add(l[lvl + 1]);
                    }
                    ++lvl;
                    continue;
                }
                if ("-".equals(t)) {
                    --lvl;
                    continue;
                }
                ViewPanel view = this.getView(t);
                if (view == null) {
                    return false;
                }
                l[lvl].add(view);
                ++nv;
            }
            if (nv == this.views.length) {
                return true;
            }
            Util.errln(Util.className(this) + ": initializing views: " + cnstr, new Object[0]);
        }
        catch (Exception ex) {
            Util.debug(ex);
            Util.errln(Util.className(this) + ": could not build layout: " + cnstr, new Object[0]);
        }
        return false;
    }

    private ViewPanel getView(String name) {
        for (ViewPanel view : this.views) {
            if (!view.toString().equals(name)) continue;
            return view;
        }
        Util.debug(Util.className(this) + ": Unknown view \"%\"", name);
        return null;
    }

    private static enum Target {
        NORTH,
        WEST,
        EAST,
        SOUTH;

    }
}

