/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.resource;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.atomic.DataClip;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.hash.TokenBoolMap;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class Docs {
    private final Data data;
    private IntList docList;
    private TokenList pathList;
    private int[] pathOrder;

    Docs(Data d) {
        this.data = d;
    }

    synchronized void read(DataInput in) throws IOException {
        this.docList = in.readDiffs();
    }

    void write(DataOutput out) throws IOException {
        out.writeDiffs(this.docs());
    }

    synchronized void init() {
        this.docList = null;
        this.pathList = null;
        this.docs();
    }

    synchronized IntList docs() {
        if (this.docList == null) {
            int k;
            IntList il = new IntList();
            int is = this.data.meta.size;
            for (int i = 0; i < is; i += this.data.size(i, k)) {
                k = this.data.kind(i);
                if (k != 0) continue;
                il.add(i);
            }
            this.data.meta.dirty = true;
            this.docList = il;
        }
        return this.docList;
    }

    private synchronized TokenList paths() {
        if (this.pathList == null) {
            IntList docs = this.docs();
            int ds = docs.size();
            TokenList paths = new TokenList(ds);
            for (int d = 0; d < ds; ++d) {
                paths.add(Docs.normalize(this.data.text(docs.get(d), true)));
            }
            this.pathList = paths;
        }
        return this.pathList;
    }

    private synchronized int[] order() {
        if (this.pathOrder == null) {
            this.pathOrder = Array.createOrder(this.paths().toArray(), false, true);
        }
        return this.pathOrder;
    }

    void insert(int pre, DataClip clip) {
        int k;
        IntList pres = new IntList();
        for (int dpre = clip.start; dpre < clip.end; dpre += clip.data.size(dpre, k)) {
            k = clip.data.kind(dpre);
            if (k != 0) continue;
            pres.add(pre + dpre);
        }
        int[] presA = pres.toArray();
        IntList docs = this.docs();
        TokenList paths = this.paths();
        int i = docs.sortedIndexOf(pre);
        if (i < 0) {
            i = -i - 1;
        }
        docs.insert(i, presA);
        docs.move(clip.size(), i + pres.size());
        byte[][] t = new byte[presA.length][];
        for (int j = 0; j < t.length; ++j) {
            t[j] = Docs.normalize(clip.data.text(presA[j] - pre, true));
        }
        paths.insert(i, t);
        this.pathOrder = null;
    }

    void delete(int pre, int size) {
        boolean found;
        IntList docs = this.docs();
        TokenList paths = this.paths();
        int i = docs.sortedIndexOf(pre);
        boolean bl = found = i >= 0;
        if (i < 0) {
            i = -i - 1;
        } else {
            docs.deleteAt(i);
        }
        docs.move(-size, i);
        if (!found) {
            return;
        }
        paths.deleteAt(i);
        this.pathOrder = null;
    }

    void rename(int pre, byte[] value) {
        IntList docs = this.docs();
        TokenList paths = this.paths();
        paths.set(docs.sortedIndexOf(pre), Docs.normalize(value));
        this.pathOrder = null;
    }

    void replace(int pre, int size, DataClip clip) {
        this.delete(pre, size);
        this.insert(pre, clip);
    }

    synchronized IntList docs(String path, boolean exact) {
        String pth = MetaData.normPath(path);
        if (pth == null) {
            return new IntList(0);
        }
        IntList docs = this.docs();
        if (pth.isEmpty()) {
            return docs;
        }
        byte[] exct = Token.EMPTY;
        byte[] pref = Docs.normalize(Token.token(pth));
        if (!pth.endsWith("/")) {
            exct = pref;
            pref = Token.concat(exct, Token.SLASH);
        }
        IntList il = new IntList();
        TokenList paths = this.paths();
        for (int p = 0; p < paths.size(); ++p) {
            byte[] b = paths.get(p);
            if (!Token.eq(b, exct) && (exact || !Token.startsWith(b, pref))) continue;
            il.add(docs.get(p));
        }
        return il.sort();
    }

    synchronized int doc(String path, boolean sort) {
        String pth = MetaData.normPath(path);
        if (pth == null || pth.isEmpty()) {
            return -1;
        }
        byte[] exct = Docs.normalize(Token.token(pth));
        IntList docs = this.docs();
        TokenList paths = this.paths();
        int ts = paths.size();
        if (sort) {
            int[] order = this.order();
            int p = this.find(exct);
            return p > -1 && p < ts && Token.eq(paths.get(order[p]), exct) ? docs.get(order[p]) : -1;
        }
        for (int t = 0; t < ts; ++t) {
            if (!Token.eq(paths.get(t), exct)) continue;
            return docs.get(t);
        }
        return -1;
    }

    synchronized boolean isDir(byte[] path) {
        byte[] pa = Token.concat(path, Token.SLASH);
        for (byte[] b : this.paths()) {
            if (!Token.startsWith(b, pa)) continue;
            return true;
        }
        return false;
    }

    synchronized void children(byte[] path, boolean dir, TokenBoolMap tbm) {
        String pth = MetaData.normPath(Token.string(path));
        if (pth == null) {
            return;
        }
        byte[] root = Token.token(pth);
        if (root.length != 0) {
            root = Token.concat(root, Token.SLASH);
        }
        IntList docs = this.docs();
        int ds = docs.size();
        for (int d = 0; d < ds; ++d) {
            byte[] np = this.data.text(docs.get(d), true);
            if (!Token.startsWith(np, root)) continue;
            np = Token.substring(np, root.length, np.length);
            int i = Token.indexOf(np, Token.SLASH);
            if (!dir && i == -1) {
                tbm.put(np, false);
                continue;
            }
            if (!dir || i < 0) continue;
            tbm.put(Token.substring(np, 0, i), false);
        }
    }

    private int find(byte[] v) {
        TokenList paths = this.paths();
        int[] po = this.pathOrder;
        int l = 0;
        int h = po.length - 1;
        while (l <= h) {
            int m = l + h >>> 1;
            int c = Token.diff(paths.get(po[m]), v);
            if (c == 0) {
                while (m > 0 && Token.eq(paths.get(po[m - 1]), v)) {
                    --m;
                }
                return m;
            }
            if (c < 0) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return l;
    }

    private static byte[] normalize(byte[] path) {
        return Token.concat(Token.SLASH, Prop.CASE ? path : Token.lc(path));
    }
}

