/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.Index;
import org.basex.index.IndexCache;
import org.basex.index.IndexEntry;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.query.NumericRange;
import org.basex.index.query.StringRange;
import org.basex.index.stats.IndexStats;
import org.basex.io.random.DataAccess;
import org.basex.util.Num;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;

public class DiskValues
implements Index {
    final DataAccess idxr;
    final DataAccess idxl;
    private final boolean text;
    final Data data;
    final IndexCache cache = new IndexCache();
    final IntObjMap<byte[]> ctext = new IntObjMap();
    private final Object monitor = new Object();
    final AtomicInteger size = new AtomicInteger();

    public DiskValues(Data d, boolean txt) throws IOException {
        this(d, txt, txt ? "txt" : "atv");
    }

    DiskValues(Data d, boolean txt, String pref) throws IOException {
        this.data = d;
        this.text = txt;
        this.idxl = new DataAccess(d.meta.dbfile(pref + 'l'));
        this.idxr = new DataAccess(d.meta.dbfile(pref + 'r'));
        this.size.set(this.idxl.read4());
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] info() {
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: Sorted List" + Text.NL);
        IndexStats stats = new IndexStats(this.data.meta.options.get(MainOptions.MAXSTAT));
        Object object = this.monitor;
        synchronized (object) {
            long l = this.idxl.length() + this.idxr.length();
            tb.add("- Size: " + Performance.format(l, true) + Text.NL);
            int s = this.size.get();
            for (int m = 0; m < s; ++m) {
                long pos = this.idxr.read5((long)m * 5L);
                int oc = this.idxl.readNum(pos);
                if (!stats.adding(oc)) continue;
                stats.add(this.data.text(this.pre(this.idxl.readNum()), this.text));
            }
        }
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public int costs(IndexToken it) {
        if (it instanceof StringRange) {
            return this.idRange((StringRange)it).size();
        }
        if (it instanceof NumericRange) {
            return this.idRange((NumericRange)it).size();
        }
        byte[] key = it.get();
        return key.length <= this.data.meta.maxlen ? this.entry((byte[])key).size : Integer.MAX_VALUE;
    }

    @Override
    public IndexIterator iter(IndexToken it) {
        if (it instanceof StringRange) {
            return this.idRange((StringRange)it);
        }
        if (it instanceof NumericRange) {
            return this.idRange((NumericRange)it);
        }
        IndexEntry e = this.entry(it.get());
        return this.iter(e.size, e.pointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexEntry entry(byte[] tok) {
        long pointer;
        int count;
        IndexEntry e = this.cache.get(tok);
        if (e != null) {
            return e;
        }
        long p = this.get(tok);
        if (p < 0L) {
            return new IndexEntry(tok, 0, 0L);
        }
        Object object = this.monitor;
        synchronized (object) {
            long pos = this.idxr.read5(p * 5L);
            count = this.idxl.readNum(pos);
            pointer = this.idxl.cursor();
        }
        return this.cache.add(tok, count, pointer);
    }

    @Override
    public EntryIterator entries(IndexEntries input) {
        byte[] key = input.get();
        if (key.length == 0) {
            return this.allKeys(input.descending);
        }
        if (input.prefix) {
            return this.keysWithPrefix(key);
        }
        return this.keysFrom(key, input.descending);
    }

    private EntryIterator allKeys(boolean reverse) {
        int s = this.size.get() - 1;
        return reverse ? this.keysWithinReverse(0, s) : this.keysWithin(0, s);
    }

    private EntryIterator keysFrom(byte[] key, boolean reverse) {
        int s = this.size.get() - 1;
        int i = this.get(key);
        if (i < 0) {
            i = -i - 1;
        }
        return reverse ? this.keysWithinReverse(0, i - 1) : this.keysWithin(i, s);
    }

    private EntryIterator keysWithPrefix(final byte[] prefix) {
        final int i = this.get(prefix);
        return new EntryIterator(){
            final int s;
            int ix;
            int count;
            {
                this.s = DiskValues.this.size.get();
                this.ix = (i < 0 ? -i - 1 : i) - 1;
                this.count = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] next() {
                if (++this.ix < this.s) {
                    Object object = DiskValues.this.monitor;
                    synchronized (object) {
                        IndexEntry entry = DiskValues.this.readKeyAt(this.ix);
                        if (Token.startsWith(entry.key, prefix)) {
                            this.count = entry.size;
                            return entry.key;
                        }
                    }
                }
                this.count = -1;
                return null;
            }

            @Override
            public int count() {
                return this.count;
            }
        };
    }

    private EntryIterator keysWithin(final int first, final int last) {
        return new EntryIterator(){
            int ix;
            int count;
            {
                this.ix = first - 1;
                this.count = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] next() {
                if (++this.ix <= last) {
                    Object object = DiskValues.this.monitor;
                    synchronized (object) {
                        IndexEntry entry = DiskValues.this.readKeyAt(this.ix);
                        this.count = entry.size;
                        return entry.key;
                    }
                }
                this.count = -1;
                return null;
            }

            @Override
            public int count() {
                return this.count;
            }
        };
    }

    private EntryIterator keysWithinReverse(final int first, final int last) {
        return new EntryIterator(){
            int ix;
            int count;
            {
                this.ix = last + 1;
                this.count = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] next() {
                if (--this.ix >= first) {
                    Object object = DiskValues.this.monitor;
                    synchronized (object) {
                        IndexEntry entry = DiskValues.this.readKeyAt(this.ix);
                        this.count = entry.size;
                        return entry.key;
                    }
                }
                this.count = -1;
                return null;
            }

            @Override
            public int count() {
                return this.count;
            }
        };
    }

    private IndexEntry readKeyAt(int index) {
        IndexEntry entry;
        byte[] key = this.ctext.get(index);
        if (key != null && (entry = this.cache.get(key)) != null) {
            return entry;
        }
        long pos = this.idxr.read5((long)index * 5L);
        int cnt = this.idxl.readNum(pos);
        if (key == null) {
            int id = this.idxl.readNum();
            key = this.data.text(this.pre(id), this.text);
        }
        return this.cache.add(key, cnt, pos + (long)Num.length(cnt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexIterator iter(int s, long ps) {
        IntList pres = new IntList(s);
        long p = ps;
        Object object = this.monitor;
        synchronized (object) {
            int id = 0;
            for (int i = 0; i < s; ++i) {
                p = this.idxl.cursor();
                pres.add(this.pre(id += this.idxl.readNum(p)));
            }
        }
        return DiskValues.iter(pres.sort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexIterator idRange(StringRange tok) {
        IntList pres = new IntList();
        Object object = this.monitor;
        synchronized (object) {
            int l;
            int i = this.get(tok.min);
            int s = this.size.get();
            int n = i < 0 ? -i - 1 : (l = tok.mni ? i : i + 1);
            while (l < s) {
                int ps = this.idxl.readNum(this.idxr.read5((long)l * 5L));
                int id = this.idxl.readNum();
                int pre = this.pre(id);
                int d = Token.diff(this.data.text(pre, this.text), tok.max);
                if (d > 0 || !tok.mxi && d == 0) break;
                for (int p = 0; p < ps; ++p) {
                    pres.add(this.pre(id));
                    id += this.idxl.readNum();
                }
                ++l;
            }
        }
        return DiskValues.iter(pres.sort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexIterator idRange(NumericRange tok) {
        double min = tok.min;
        double max = tok.max;
        int len = max > 0.0 && (double)((long)max) == max ? Token.token(max).length : 0;
        boolean simple = len != 0 && min > 0.0 && (double)((long)min) == min && Token.token(min).length == len;
        IntList pres = new IntList();
        Object object = this.monitor;
        synchronized (object) {
            int s = this.size.get();
            for (int l = 0; l < s; ++l) {
                int ds = this.idxl.readNum(this.idxr.read5((long)l * 5L));
                int id = this.idxl.readNum();
                int pre = this.pre(id);
                double v = this.data.textDbl(pre, this.text);
                if (v >= min && v <= max) {
                    for (int d = 0; d < ds; ++d) {
                        pres.add(this.pre(id));
                        id += this.idxl.readNum();
                    }
                    continue;
                }
                if (simple && v > max && this.data.textLen(pre, this.text) == len) break;
            }
        }
        return DiskValues.iter(pres.sort());
    }

    private static IndexIterator iter(final IntList pres) {
        return new IndexIterator(){
            final int s;
            int p;
            {
                this.s = pres.size();
                this.p = -1;
            }

            @Override
            public boolean more() {
                return ++this.p < this.s;
            }

            @Override
            public int pre() {
                return pres.get(this.p);
            }

            @Override
            public int size() {
                return this.s;
            }
        };
    }

    int pre(int id) {
        return id;
    }

    int get(byte[] key) {
        return this.get(key, 0, this.size.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int get(byte[] key, int first, int last) {
        int l = first;
        int h = last - 1;
        Object object = this.monitor;
        synchronized (object) {
            while (l <= h) {
                int m = l + h >>> 1;
                byte[] txt = this.readKeyAt((int)m).key;
                int d = Token.diff(txt, key);
                if (d == 0) {
                    return m;
                }
                if (d < 0) {
                    l = m + 1;
                    continue;
                }
                h = m - 1;
            }
        }
        return -(l + 1);
    }

    public void flush() {
        this.idxl.flush();
        this.idxr.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.monitor;
        synchronized (object) {
            this.flush();
            this.idxl.close();
            this.idxr.close();
        }
    }

    public void index(TokenObjMap<IntList> m) {
    }

    public void delete(TokenObjMap<IntList> m) {
    }

    public void replace(byte[] o, byte[] n, int id) {
    }
}

