/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.xml.sax.InputSource;

public final class IOFile
extends IO {
    private static final Pattern VALIDNAME = Pattern.compile("^[^\\\\/" + (Prop.WIN ? ":*?\"<>\\|" : "") + "]+$");
    private final File file;

    public IOFile(String f) {
        this(new File(f));
    }

    public IOFile(File fl) {
        super(new PathList().create(fl.getAbsolutePath()));
        this.file = fl.isAbsolute() ? fl : fl.getAbsoluteFile();
    }

    public IOFile(String dir, String n) {
        this(new File(dir, n));
    }

    public IOFile(IOFile dir, String n) {
        this(new File(dir.file, n));
    }

    public File file() {
        return this.file;
    }

    public boolean touch() {
        for (int i = 0; i < 5; ++i) {
            try {
                if (!this.file.createNewFile()) continue;
                return true;
            }
            catch (IOException ex) {
                Performance.sleep((long)i * 10L);
                Util.debug(ex);
            }
        }
        return false;
    }

    @Override
    public byte[] read() throws IOException {
        return new BufferInput(this).content();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDir() {
        return this.file.isDirectory();
    }

    @Override
    public long timeStamp() {
        return this.file.lastModified();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public InputSource inputSource() {
        return new InputSource(this.path);
    }

    @Override
    public StreamSource streamSource() {
        return new StreamSource(this.path);
    }

    @Override
    public InputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public IO merge(String f) {
        IO io = IO.get(f);
        if (!(io instanceof IOFile) || f.contains(":") || f.startsWith("/")) {
            return io;
        }
        return new IOFile(this.dir(), f);
    }

    public boolean md() {
        return !this.file.exists() && this.file.mkdirs();
    }

    @Override
    public String dirPath() {
        return this.isDir() ? this.path : this.path.substring(0, this.path.lastIndexOf(47) + 1);
    }

    public IOFile dir() {
        return this.isDir() ? this : new IOFile(this.path.substring(0, this.path.lastIndexOf(47) + 1));
    }

    public IOFile[] children() {
        return this.children(".*");
    }

    public IOFile[] children(String regex) {
        File[] ch = this.file.listFiles();
        if (ch == null) {
            return new IOFile[0];
        }
        ArrayList<IOFile> io = new ArrayList<IOFile>(ch.length);
        Pattern p = Pattern.compile(regex, Prop.CASE ? 0 : 2);
        for (File f : ch) {
            if (!p.matcher(f.getName()).matches()) continue;
            io.add(new IOFile(f));
        }
        return io.toArray(new IOFile[io.size()]);
    }

    public synchronized StringList descendants() {
        StringList files = new StringList();
        File[] ch = this.file.listFiles();
        if (ch == null) {
            return files;
        }
        if (this.exists()) {
            IOFile.add(this, files, this.path().length() + 1);
        }
        return files;
    }

    private static void add(IOFile io, StringList files, int off) {
        if (io.isDir()) {
            for (IOFile f : io.children()) {
                IOFile.add(f, files, off);
            }
        } else {
            files.add(io.path().substring(off).replace('\\', '/'));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] c) throws IOException {
        FileOutputStream out = new FileOutputStream(this.path);
        try {
            out.write(c);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream in) throws IOException {
        try {
            BufferOutput out = new BufferOutput(this.path);
            try {
                int i;
                while ((i = in.read()) != -1) {
                    out.write(i);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    public boolean delete() {
        if (this.file.exists()) {
            boolean ok = true;
            if (this.isDir()) {
                for (IOFile ch : this.children()) {
                    ok &= ch.delete();
                }
            }
            for (int i = 0; i < 5; ++i) {
                if (this.file.delete() && !this.file.exists()) {
                    return ok;
                }
                Performance.sleep((long)i * 10L);
            }
        }
        return false;
    }

    public boolean rename(IOFile target) {
        return this.file.renameTo(target.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(IOFile target) throws IOException {
        int bsize = (int)Math.max(1L, Math.min(this.length(), 0x400000L));
        byte[] buf = new byte[bsize];
        target.dir().md();
        FileInputStream fis = new FileInputStream(this.file);
        try {
            FileOutputStream fos = new FileOutputStream(target.file);
            try {
                int i;
                while ((i = fis.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
            }
            finally {
                fos.close();
            }
        }
        finally {
            fis.close();
        }
    }

    @Override
    public boolean eq(IO io) {
        return io instanceof IOFile && (Prop.CASE ? this.path.equals(io.path) : this.path.equalsIgnoreCase(io.path));
    }

    @Override
    public String url() {
        TokenBuilder tb = new TokenBuilder("file:");
        if (!this.path.startsWith("/")) {
            tb.add("///");
        }
        for (int p = 0; p < this.path.length(); ++p) {
            char ch = this.path.charAt(p);
            if (ch == ' ') {
                tb.add("%20");
                continue;
            }
            tb.add(ch);
        }
        if (this.isDir()) {
            tb.add(47);
        }
        return tb.toString();
    }

    public void open() throws IOException {
        String[] args = Prop.WIN ? new String[]{"rundll32", "url.dll,FileProtocolHandler", this.path} : (Prop.MAC ? new String[]{"/usr/bin/open", this.path} : new String[]{"xdg-open", this.path});
        new ProcessBuilder(args).directory(this.dir().file).start();
    }

    public static boolean isValidName(String name) {
        return VALIDNAME.matcher(name).matches();
    }

    public static boolean isValid(String s) {
        return s.length() < 3 || s.indexOf(58) == -1 || Token.letter(s.charAt(0)) && s.charAt(1) == ':';
    }

    public static String regex(String glob) {
        return IOFile.regex(glob, true);
    }

    public static String regex(String glob, boolean sub) {
        StringBuilder sb = new StringBuilder();
        for (String g : glob.split(",")) {
            String gl = g.trim();
            if (sb.length() != 0) {
                sb.append('|');
            }
            boolean suf = false;
            for (int f = 0; f < gl.length(); ++f) {
                char ch = gl.charAt(f);
                if (ch == '*') {
                    suf = true;
                    sb.append(gl.endsWith(".") ? "[^.]" : ".");
                } else if (ch == '?') {
                    ch = '.';
                    suf = true;
                } else if (ch == '.') {
                    suf = true;
                    if (f + 1 == gl.length()) break;
                    sb.append('\\');
                } else if (!Character.isLetterOrDigit(ch)) {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            if (suf || !sub) continue;
            sb.append(".*");
        }
        return Prop.CASE ? sb.toString() : sb.toString().toLowerCase(Locale.ENGLISH);
    }

    public static IOFile get(String url) {
        String file = url;
        try {
            if (file.indexOf(37) != -1) {
                file = URLDecoder.decode(file, Prop.ENCODING);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file.startsWith("file:")) {
            file = file.substring("file:".length());
        }
        if ((file = IOFile.normSlashes(file)).length() > 2 && file.charAt(0) == '/' && file.charAt(2) == ':' && Token.letter(file.charAt(1))) {
            file = file.substring(1);
        }
        return new IOFile(file);
    }

    private static String normSlashes(String path) {
        boolean a = true;
        StringBuilder sb = new StringBuilder(path.length());
        int pl = path.length();
        for (int p = 0; p < pl; ++p) {
            boolean b;
            char c = path.charAt(p);
            boolean bl = b = c != '/';
            if (a || b) {
                sb.append(c);
            }
            a = b;
        }
        return sb.toString();
    }

    static class PathList
    extends StringList {
        PathList() {
        }

        String create(String path) {
            TokenBuilder tb = new TokenBuilder();
            int l = path.length();
            for (int i = 0; i < l; ++i) {
                char ch = path.charAt(i);
                if (ch == '\\' || ch == '/') {
                    this.add(tb);
                    continue;
                }
                tb.add(ch);
            }
            this.add(tb);
            if (path.startsWith("\\\\") || path.startsWith("//")) {
                tb.add("//");
            }
            for (int s = 0; s < this.size; ++s) {
                if (s != 0 || path.startsWith("/")) {
                    tb.add(47);
                }
                tb.add(this.list[s]);
            }
            return tb.toString();
        }

        private void add(TokenBuilder tb) {
            String s = tb.toString();
            if (s.length() > 1 && s.charAt(1) == ':' && this.size == 0) {
                s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
            }
            if ("..".equals(s) && this.size > 0) {
                if (this.list[this.size - 1].indexOf(58) == -1) {
                    this.deleteAt(this.size - 1);
                }
            } else if (!".".equals(s) && !s.isEmpty()) {
                this.add(s);
            }
            tb.reset();
        }
    }
}

