/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.io.serial.Serializer;
import org.basex.query.value.item.Item;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.Util;

public class BuilderSerializer
extends Serializer {
    private final Atts atts = new Atts();
    private final Atts nsp = new Atts();
    private final Builder build;

    public BuilderSerializer(Builder b) {
        this.build = b;
    }

    @Override
    protected final void finishText(byte[] b) throws IOException {
        this.build.text(b);
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
    }

    @Override
    protected final void finishPi(byte[] n, byte[] v) throws IOException {
        this.build.pi(Token.concat(n, Token.SPACE, v));
    }

    @Override
    protected final void atomic(Item b, boolean iter) {
        throw Util.notExpected(new Object[0]);
    }

    @Override
    protected final void finishOpen() throws IOException {
        this.build.openElem(this.tag, this.atts, this.nsp);
        this.atts.clear();
        this.nsp.clear();
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.build.emptyElem(this.tag, this.atts, this.nsp);
        this.atts.clear();
        this.nsp.clear();
    }

    @Override
    protected void finishClose() throws IOException {
        this.build.closeElem();
    }

    @Override
    protected final void finishComment(byte[] b) throws IOException {
        this.build.comment(b);
    }

    @Override
    protected final void attribute(byte[] n, byte[] v) {
        if (Token.startsWith(n, Token.XMLNS)) {
            if (n.length == 5) {
                this.nsp.add(Token.EMPTY, v);
            } else if (n[5] == 58) {
                this.nsp.add(Token.substring(n, 6), v);
            } else {
                this.atts.add(n, v);
            }
        } else {
            this.atts.add(n, v);
        }
    }

    @Override
    protected void openDoc(byte[] name) throws IOException {
        this.build.openDoc(name);
    }

    @Override
    protected final void closeDoc() throws IOException {
        this.build.closeDoc();
    }
}

