/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.csv.CsvSerializer;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.type.AtomType;
import org.basex.util.list.TokenList;

public class CsvMapSerializer
extends CsvSerializer {
    public CsvMapSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (this.sep && this.level == 0) {
            this.print(32);
        }
        if (!(item instanceof Map)) {
            throw Err.BXCS_SERIAL.getIO("Top level must be a map; " + item.type + " found");
        }
        try {
            TokenList tl = new TokenList();
            Map map = (Map)item;
            Value keys = map.keys();
            long rows = 0L;
            for (Item key : keys) {
                if (key.type != AtomType.ITR) {
                    throw Err.BXCS_SERIAL.getIO("Key " + key + " is not numeric");
                }
                long n = key.itr(null);
                if (n <= 0L) {
                    throw Err.BXCS_SERIAL.getIO("Key '" + n + "' is no positive integer");
                }
                rows = Math.max(rows, n);
            }
            int i = 0;
            while ((long)i < rows) {
                Value row = map.get(Int.get(i + 1), null);
                if (row.size() == 1L && row instanceof Map) {
                    Map r = (Map)row;
                    if (i == 0) {
                        for (Item key : r.keys()) {
                            tl.add(key.string(null));
                        }
                        this.record(tl);
                        tl.reset();
                    }
                    for (Item key : r.keys()) {
                        Value val = r.get(key, null);
                        if (val.size() != 1L) {
                            throw Err.BXCS_SERIAL.getIO("Single value expected as entry.");
                        }
                        tl.add(((Item)val).string(null));
                    }
                } else {
                    for (Item it : row) {
                        tl.add(it.string(null));
                    }
                }
                this.record(tl);
                tl.reset();
                ++i;
            }
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
        this.sep = true;
    }
}

