/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.CsvOptions;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;

abstract class CsvSerializer
extends OutputSerializer {
    final CsvOptions copts;
    private final int separator;
    private final boolean quotes;

    CsvSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts, new String[0]);
        this.copts = opts.get(SerializerOptions.CSV);
        this.quotes = this.copts.get(CsvOptions.QUOTES);
        this.separator = this.copts.separator();
    }

    void record(TokenList fields) throws IOException {
        int fs = fields.size();
        for (int i = 0; i < fs; ++i) {
            byte[] txt;
            byte[] v = fields.get(i);
            if (i != 0) {
                this.print(this.separator);
            }
            byte[] byArray = txt = v == null ? Token.EMPTY : v;
            if (Token.contains(txt, this.separator) || this.quotes && (Token.contains(txt, 10) || Token.contains(txt, 34))) {
                TokenBuilder tb = new TokenBuilder().add(34);
                int len = txt.length;
                for (int c = 0; c < len; c += Token.cl(txt, c)) {
                    int cp = Token.cp(txt, c);
                    if (cp == 34) {
                        tb.add(34);
                    }
                    tb.add(cp);
                }
                txt = tb.add(34).finish();
            }
            this.print(txt);
        }
        this.print(this.nl);
    }
}

