/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.build.JsonOptions;
import org.basex.build.JsonParserOptions;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.LockResult;
import org.basex.core.MainOptions;
import org.basex.core.Proc;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.FTPosData;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.io.IO;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.LibraryModule;
import org.basex.query.MainModule;
import org.basex.query.QueryCompiler;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryParser;
import org.basex.query.QueryProcessor;
import org.basex.query.QueryResources;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.StaticScope;
import org.basex.query.expr.Expr;
import org.basex.query.expr.XQFunction;
import org.basex.query.func.JavaMapping;
import org.basex.query.func.StaticFuncs;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.up.Updates;
import org.basex.query.util.ClientSessions;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.util.JDBCConnections;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.value.Value;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Tim;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.NodeType;
import org.basex.query.var.QueryStack;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.Variables;
import org.basex.util.DateTime;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;
import org.basex.util.options.Option;

public final class QueryContext
extends Proc {
    private static final Pattern BIND = Pattern.compile("^((\"|')(.*?)\\2:|Q?(\\{(.*?)\\}))(.+)$");
    public final QueryStack stack = new QueryStack();
    public final Variables vars = new Variables();
    public final StaticFuncs funcs = new StaticFuncs();
    private final HashMap<QNm, Expr> bindings = new HashMap();
    public final QueryResources resource = new QueryResources(this);
    public final Context context;
    public Object http;
    public HashMap<String, IO> stop;
    public HashMap<String, IO> thes;
    public final HashMap<Option<?>, Object> staticOpts = new HashMap();
    public final StringList tempOpts = new StringList();
    public Value value;
    public long pos = 1L;
    public long size = 1L;
    Nodes nodes;
    public TokenObjMap<Collation> collations;
    public FTLexer ftToken;
    private FTOpt ftOpt;
    public FTPosData ftPosData;
    public int ftPos;
    public Item date;
    public Item dtm;
    public Item time;
    public Item zone;
    public final StringList readLocks = new StringList(0);
    public final StringList writeLocks = new StringList(0);
    public Updates updates;
    public final ValueBuilder output = new ValueBuilder();
    public boolean leaf;
    public int tailCalls;
    public int maxCalls;
    private XQFunction tailFunc;
    private Value[] args;
    public int varIDs;
    final TokenMap modDeclared = new TokenMap();
    final TokenMap modParsed = new TokenMap();
    final TokenList modStack = new TokenList();
    SerializerOptions serialOpts;
    public MainModule ctxItem;
    private ModuleLoader modules;
    private JDBCConnections jdbc;
    private ClientSessions sessions;
    MainModule root;
    private QueryContext parentCtx;
    public final QueryInfo info;
    private boolean closed;

    public QueryContext(QueryContext parent) {
        this(parent.context);
        this.parentCtx = parent;
        this.listen = parent.listen;
    }

    public QueryContext(Context ctx) {
        this.context = ctx;
        this.info = new QueryInfo(this);
    }

    public StaticScope parse(String qu, String path, StaticContext sc) throws QueryException {
        return this.parse(qu, QueryProcessor.isLibrary(qu), path, sc);
    }

    public StaticScope parse(String qu, boolean library, String path, StaticContext sc) throws QueryException {
        return library ? this.parseLibrary(qu, path, sc) : this.parseMain(qu, path, sc);
    }

    public MainModule parseMain(String qu, String path, StaticContext sc) throws QueryException {
        this.info.query = qu;
        this.root = new QueryParser(qu, path, this, sc).parseMain();
        return this.root;
    }

    public LibraryModule parseLibrary(String qu, String path, StaticContext sc) throws QueryException {
        this.info.query = qu;
        return new QueryParser(qu, path, this, sc).parseLibrary(true);
    }

    public void mainModule(MainModule rt) {
        this.root = rt;
        this.updating = rt.expr.has(Expr.Flag.UPD);
    }

    public void compile() throws QueryException {
        if (this.nodes == null) {
            this.nodes = this.context.current();
        }
        StringList o = this.tempOpts;
        for (int s = 0; s < o.size(); s += 2) {
            try {
                this.context.options.assign(o.get(s).toUpperCase(Locale.ENGLISH), o.get(s + 1));
                continue;
            }
            catch (BaseXException ex) {
                throw Err.BASX_VALUE.get(null, o.get(s), o.get(s + 1));
            }
        }
        this.maxCalls = this.context.options.get(MainOptions.TAILCALLS);
        this.vars.bindExternal(this, this.bindings);
        if (this.ctxItem != null) {
            try {
                this.ctxItem.compile(this);
                this.value = this.ctxItem.value(this);
            }
            catch (QueryException ex) {
                if (ex.err() != Err.NOCTX) {
                    throw ex;
                }
                throw Err.CIRCCTX.get(this.ctxItem.info, new Object[0]);
            }
        } else if (this.nodes != null) {
            if (this.nodes.ftpos != null) {
                this.ftPosData = new FTPosData();
            }
            this.resource.compile(this.nodes);
        }
        if (this.value != null && this.root.sc.initType != null) {
            this.value = this.root.sc.initType.promote(this, this.root.sc, null, this.value, true);
        }
        this.analyze();
        this.info.runtime = true;
    }

    private void analyze() throws QueryException {
        try {
            if (this.root != null) {
                QueryCompiler.compile(this, this.root);
            } else {
                this.funcs.compile(this);
            }
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw Err.BASX_STACKOVERFLOW.get(null, ex);
        }
    }

    public Iter iter() throws QueryException {
        try {
            return this.updating ? this.value().iter() : this.root.iter(this);
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw Err.BASX_STACKOVERFLOW.get(null, new Object[0]);
        }
    }

    public Value value() throws QueryException {
        try {
            Value v = this.root.value(this);
            Value u = this.update();
            return u != null ? u : v;
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw Err.BASX_STACKOVERFLOW.get(null, new Object[0]);
        }
    }

    private Value update() throws QueryException {
        if (this.updating) {
            this.updates.apply();
            if (this.updates.size() != 0 && this.context.data() != null) {
                this.context.update();
            }
            if (this.output.size() != 0L) {
                return this.output.value();
            }
        }
        return null;
    }

    public Iter iter(Expr e) throws QueryException {
        this.checkStop();
        return e.iter(this);
    }

    public Value value(Expr expr) throws QueryException {
        this.checkStop();
        return expr.value(this);
    }

    public Data data() {
        return this.value != null ? this.value.data() : null;
    }

    @Override
    public void databases(LockResult lr) {
        lr.read.add(this.readLocks);
        lr.write.add(this.writeLocks);
        if (this.root == null || !this.root.databases(lr, this) || this.ctxItem != null && !this.ctxItem.databases(lr, this)) {
            if (this.updating) {
                lr.writeAll = true;
            } else {
                lr.readAll = true;
            }
        }
    }

    public void http(Object val) {
        this.http = val;
    }

    public void context(Object val, String type, StaticContext sc) throws QueryException {
        this.ctxItem = new MainModule(this.cast(val, type), new VarScope(sc), null, sc);
    }

    public void bind(String name, Object val, String type) throws QueryException {
        this.bind(name, this.cast(val, type));
    }

    public void compInfo(String string, Object ... ext) {
        this.info.compInfo(string, ext);
    }

    public void evalInfo(String string) {
        (this.parentCtx != null ? this.parentCtx.info : this.info).evalInfo(string);
    }

    public String info() {
        return this.info.toString(this);
    }

    public ModuleLoader modules() {
        if (this.modules == null) {
            this.modules = new ModuleLoader(this.context);
        }
        return this.modules;
    }

    public JDBCConnections jdbc() {
        if (this.jdbc == null) {
            this.jdbc = new JDBCConnections();
        }
        return this.jdbc;
    }

    public ClientSessions sessions() {
        if (this.sessions == null) {
            this.sessions = new ClientSessions();
        }
        return this.sessions;
    }

    public SerializerOptions serParams() {
        return this.serialOpts != null ? this.serialOpts : this.context.options.get(MainOptions.SERIALIZER);
    }

    public FTOpt ftOpt() {
        if (this.ftOpt == null) {
            this.ftOpt = new FTOpt();
        }
        return this.ftOpt;
    }

    public void ftOpt(FTOpt opt) {
        this.ftOpt = opt;
    }

    public void updating(boolean up) {
        if (this.updates == null) {
            this.updates = new Updates();
        }
        this.updating = up;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (Map.Entry<Option<?>, Object> e : this.staticOpts.entrySet()) {
            this.context.options.put(e.getKey(), e.getValue());
        }
        this.resource.close();
        if (this.jdbc != null) {
            this.jdbc.close();
        }
        if (this.sessions != null) {
            this.sessions.close();
        }
        if (this.modules != null) {
            this.modules.close();
        }
    }

    @Override
    public String tit() {
        return Text.SAVE;
    }

    @Override
    public String det() {
        return Text.PLEASE_WAIT_D;
    }

    @Override
    public double prog() {
        return 0.0;
    }

    Result execute() throws QueryException {
        Item it;
        int max = this.context.options.get(MainOptions.MAXHITS);
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        Iter ir = this.iter();
        ValueBuilder vb = new ValueBuilder();
        if (this.serialOpts == null && this.nodes != null) {
            IntList pre = new IntList();
            while ((it = ir.next()) != null) {
                this.checkStop();
                if (it.data() != this.nodes.data) break;
                if (pre.size() >= max) continue;
                pre.add(((DBNode)it).pre);
            }
            int ps = pre.size();
            if (it == null || ps == max) {
                return ps == 0 ? vb : new Nodes(pre.toArray(), this.nodes.data, this.ftPosData);
            }
            for (int p = 0; p < ps; ++p) {
                vb.add(new DBNode(this.nodes.data, pre.get(p)));
            }
            vb.add(it);
        }
        while ((it = ir.next()) != null) {
            this.checkStop();
            if (vb.size() >= (long)max) continue;
            vb.add(it.materialize(null));
        }
        return vb;
    }

    void plan(FDoc doc) {
        FElem e = new FElem(QueryText.PLAN);
        if (this.root != null) {
            for (StaticScope staticScope : QueryCompiler.usedDecls(this.root)) {
                staticScope.plan(e);
            }
        } else {
            this.funcs.plan(e);
            this.vars.plan(e);
        }
        this.root.plan(e);
        doc.add(e);
    }

    private void bind(String name, Expr e) {
        String nm = name.indexOf(36) == 0 ? name.substring(1) : name;
        byte[] uri = Token.EMPTY;
        Matcher m = BIND.matcher(nm);
        if (m.find()) {
            String u = m.group(3);
            if (u == null) {
                u = m.group(5);
            }
            uri = Token.token(u);
            nm = m.group(6);
        }
        byte[] ln = Token.token(nm);
        if (nm.isEmpty() || !XMLToken.isNCName(ln)) {
            return;
        }
        this.bindings.put(new QNm(ln, uri), e);
    }

    private Expr cast(Object val, String type) throws QueryException {
        Enum t;
        StaticContext sc;
        StaticContext staticContext = sc = this.root != null ? this.root.sc : new StaticContext(true);
        if (type == null || type.isEmpty()) {
            return val instanceof Expr ? (Expr)val : JavaMapping.toValue(val, this, sc);
        }
        try {
            if (type.equalsIgnoreCase(MainOptions.MainParser.JSON.toString())) {
                JsonParserOptions jp = new JsonParserOptions();
                jp.set(JsonOptions.SPEC, JsonOptions.JsonSpec.ECMA_262);
                jp.set(JsonOptions.FORMAT, JsonOptions.JsonFormat.MAP);
                JsonConverter conv = JsonConverter.get(jp);
                conv.convert(Token.token(val.toString()), null);
                return conv.finish();
            }
        }
        catch (QueryIOException ex) {
            throw ex.getCause();
        }
        QNm nm = new QNm(Token.token(type.replaceAll("\\(.*?\\)$", "")), sc);
        if (!nm.hasURI() && nm.hasPrefix()) {
            throw Err.NOURI.get(null, new Object[]{nm.string()});
        }
        if (type.endsWith(")")) {
            t = NodeType.find(nm);
        } else {
            t = ListType.find(nm);
            if (t == null) {
                t = AtomType.find(nm, false);
            }
        }
        if (t == null) {
            throw Err.NOTYPE.get(null, type);
        }
        return t.cast(val, this, sc, null);
    }

    public Value get(Var var) {
        return this.stack.get(var);
    }

    public void set(Var vr, Value vl, InputInfo ii) throws QueryException {
        this.stack.set(vr, vl, this, ii);
    }

    public void registerTailCall(XQFunction fn, Value[] arg) {
        this.tailFunc = fn;
        this.args = arg;
    }

    public XQFunction pollTailCall() {
        XQFunction fn = this.tailFunc;
        this.tailFunc = null;
        return fn;
    }

    public Value[] pollTailArgs() {
        Value[] as = this.args;
        this.args = null;
        return as;
    }

    public QueryContext initDateTime() throws QueryException {
        if (this.time == null) {
            Date d = Calendar.getInstance().getTime();
            String zon = DateTime.format(d, DateTime.ZONE);
            String ymd = DateTime.format(d, DateTime.DATE);
            String hms = DateTime.format(d, DateTime.TIME);
            String zn = zon.substring(0, 3) + ':' + zon.substring(3);
            this.time = new Tim(Token.token(hms + zn), null);
            this.date = new Dat(Token.token(ymd + zn), null);
            this.dtm = new Dtm(Token.token(ymd + 'T' + hms + zn), null);
            this.zone = new DTDur(Token.toInt(zon.substring(0, 3)), Token.toInt(zon.substring(3)));
        }
        return this;
    }
}

