/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.core.LockResult;
import org.basex.core.MainOptions;
import org.basex.core.Proc;
import org.basex.core.Text;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.StaticContext;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.node.FDoc;

public final class QueryProcessor
extends Proc {
    private static final Pattern LIBMOD_PATTERN = Pattern.compile("^(xquery( version ['\"].*?['\"])?( encoding ['\"].*?['\"])? ?; ?)?module namespace.*");
    public final StaticContext sc;
    public final QueryContext ctx;
    private final String query;
    private boolean parsed;
    private boolean compiled;

    public QueryProcessor(String qu, Context cx) {
        this.query = qu;
        this.ctx = this.proc(new QueryContext(cx));
        this.sc = new StaticContext(cx.options.get(MainOptions.XQUERY3));
    }

    public void parse() throws QueryException {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        this.ctx.parseMain(this.query, null, this.sc);
        this.updating = this.ctx.updating;
    }

    public void compile() throws QueryException {
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        this.parse();
        this.ctx.compile();
    }

    public Iter iter() throws QueryException {
        this.compile();
        return this.ctx.iter();
    }

    public Value value() throws QueryException {
        this.compile();
        return this.ctx.value();
    }

    public Result execute() throws QueryException {
        this.compile();
        return this.ctx.execute();
    }

    public QueryProcessor bind(String name, Object value, String type) throws QueryException {
        this.ctx.bind(name, value, type);
        return this;
    }

    public QueryProcessor bind(String name, Object value) throws QueryException {
        return this.bind(name, value, null);
    }

    public QueryProcessor context(Object value) throws QueryException {
        return this.context(value, null);
    }

    public QueryProcessor http(Object value) {
        this.ctx.http(value);
        return this;
    }

    public QueryProcessor context(Object value, String type) throws QueryException {
        this.ctx.context(value, type, this.sc);
        return this;
    }

    public QueryProcessor context(Nodes nodes) {
        this.ctx.nodes = nodes;
        return this;
    }

    public QueryProcessor namespace(String prefix, String uri) throws QueryException {
        this.sc.namespace(prefix, uri);
        return this;
    }

    public Serializer getSerializer(OutputStream os) throws IOException, QueryException {
        this.compile();
        try {
            return Serializer.get(os, this.ctx.serParams());
        }
        catch (QueryIOException ex) {
            throw ex.getCause();
        }
    }

    public Nodes queryNodes() throws QueryException {
        Result res = this.execute();
        if (res instanceof Nodes) {
            return (Nodes)res;
        }
        if (res.size() != 0L) {
            throw Err.BXDB_DBRETURN.get(null, new Object[0]);
        }
        return new Nodes(this.ctx.nodes.data);
    }

    public void module(String uri, String file) {
        this.ctx.modDeclared.put(uri, file);
    }

    public String query() {
        return this.query;
    }

    public void close() {
        this.ctx.close();
    }

    @Override
    public void databases(LockResult lr) {
        this.ctx.databases(lr);
    }

    public int updates() {
        return this.updating ? this.ctx.updates.size() : 0;
    }

    public String info() {
        return this.ctx.info();
    }

    public static boolean isLibrary(String qu) {
        return LIBMOD_PATTERN.matcher(QueryProcessor.removeComments(qu, 80)).matches();
    }

    public static String removeComments(String qu, int max) {
        StringBuilder sb = new StringBuilder();
        int m = 0;
        boolean s = false;
        int cl = qu.length();
        for (int c = 0; c < cl && sb.length() < max; ++c) {
            char ch = qu.charAt(c);
            if (ch == '\r') continue;
            if (ch == '(' && c + 1 < cl && qu.charAt(c + 1) == ':') {
                if (m == 0 && !s) {
                    sb.append(' ');
                    s = true;
                }
                ++m;
                ++c;
                continue;
            }
            if (m != 0 && ch == ':' && c + 1 < cl && qu.charAt(c + 1) == ')') {
                --m;
                ++c;
                continue;
            }
            if (m != 0) continue;
            if (ch > ' ') {
                sb.append(ch);
            } else if (!s) {
                sb.append(' ');
            }
            s = ch <= ' ';
        }
        if (sb.length() >= max) {
            sb.append("...");
        }
        return sb.toString().trim();
    }

    public FDoc plan() {
        FDoc doc = new FDoc();
        this.ctx.plan(doc);
        return doc;
    }

    @Override
    public String tit() {
        return Text.PLEASE_WAIT_D;
    }

    @Override
    public String det() {
        return Text.PLEASE_WAIT_D;
    }

    public String toString() {
        return this.query;
    }
}

