/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Arith
extends Arr {
    private final Calc calc;

    public Arith(InputInfo ii, Expr e1, Expr e2, Calc c) {
        super(ii, e1, e2);
        this.calc = c;
        this.type = SeqType.ITEM_ZO;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        SeqType s0 = this.expr[0].type();
        SeqType s1 = this.expr[1].type();
        Type t0 = s0.type;
        Type t1 = s1.type;
        if (t0.isNumberOrUntyped() && t1.isNumberOrUntyped()) {
            SeqType.Occ occ = s0.one() && s1.one() ? SeqType.Occ.ONE : SeqType.Occ.ZERO_ONE;
            this.type = SeqType.get(Calc.type(t0, t1), occ);
        } else if (s0.one() && s1.one()) {
            this.type = SeqType.ITEM;
        }
        return this.optPre(this.oneIsEmpty() ? null : (this.allAreValues() ? this.item(ctx, this.info) : this), ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item a = this.expr[0].item(ctx, this.info);
        if (a == null) {
            return null;
        }
        Item b = this.expr[1].item(ctx, this.info);
        if (b == null) {
            return null;
        }
        return this.calc.ev(this.info, a, b);
    }

    @Override
    public Arith copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Expr a = this.expr[0].copy(ctx, scp, vs);
        Expr b = this.expr[1].copy(ctx, scp, vs);
        return this.copyType(new Arith(this.info, a, b, this.calc));
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.OP, this.calc.name), this.expr);
    }

    @Override
    public String description() {
        return '\'' + this.calc.name + "' operator";
    }

    @Override
    public String toString() {
        return this.toString(' ' + this.calc.name + ' ');
    }
}

