/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public enum Calc {
    PLUS("+"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            boolean t2;
            Type ta = a.type;
            Type tb = b.type;
            boolean t1 = ta.isNumberOrUntyped();
            if (t1 ^ (t2 = tb.isNumberOrUntyped())) {
                throw this.numError(ii, t1 ? b : a);
            }
            if (t1 && t2) {
                Type t = 1.type(ta, tb);
                if (t == AtomType.ITR) {
                    long l1 = a.itr(ii);
                    long l2 = b.itr(ii);
                    if (l2 > 0L ? l1 > Long.MAX_VALUE - l2 : l1 < Long.MIN_VALUE - l2) {
                        throw Err.RANGE.get(ii, l1 + " + " + l2);
                    }
                    return Int.get(l1 + l2);
                }
                if (t == AtomType.DBL) {
                    return Dbl.get(a.dbl(ii) + b.dbl(ii));
                }
                if (t == AtomType.FLT) {
                    return Flt.get(a.flt(ii) + b.flt(ii));
                }
                return Dec.get(a.dec(ii).add(b.dec(ii)));
            }
            if (ta == tb) {
                if (!(a instanceof Dur)) {
                    throw this.numError(ii, t1 ? b : a);
                }
                if (ta == AtomType.YMD) {
                    return new YMDur((YMDur)a, (YMDur)b, true, ii);
                }
                if (ta == AtomType.DTD) {
                    return new DTDur((DTDur)a, (DTDur)b, true, ii);
                }
            }
            if (ta == AtomType.DTM) {
                return new Dtm((Dtm)a, this.checkDur(ii, b), true, ii);
            }
            if (tb == AtomType.DTM) {
                return new Dtm((Dtm)b, this.checkDur(ii, a), true, ii);
            }
            if (ta == AtomType.DAT) {
                return new Dat((Dat)a, this.checkDur(ii, b), true, ii);
            }
            if (tb == AtomType.DAT) {
                return new Dat((Dat)b, this.checkDur(ii, a), true, ii);
            }
            if (ta == AtomType.TIM && tb == AtomType.DTD) {
                return new Tim((Tim)a, (DTDur)b, true);
            }
            if (tb == AtomType.TIM && ta == AtomType.DTD) {
                return new Tim((Tim)b, (DTDur)a, true);
            }
            throw this.typeError(ii, ta, tb);
        }
    }
    ,
    MINUS("-"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            boolean t2;
            Type ta = a.type;
            Type tb = b.type;
            boolean t1 = ta.isNumberOrUntyped();
            if (t1 ^ (t2 = tb.isNumberOrUntyped())) {
                throw this.numError(ii, t1 ? b : a);
            }
            if (t1 && t2) {
                Type t = 2.type(ta, tb);
                if (t == AtomType.ITR) {
                    long l1 = a.itr(ii);
                    long l2 = b.itr(ii);
                    if (l2 < 0L ? l1 > Long.MAX_VALUE + l2 : l1 < Long.MIN_VALUE + l2) {
                        throw Err.RANGE.get(ii, l1 + " - " + l2);
                    }
                    return Int.get(l1 - l2);
                }
                if (t == AtomType.DBL) {
                    return Dbl.get(a.dbl(ii) - b.dbl(ii));
                }
                if (t == AtomType.FLT) {
                    return Flt.get(a.flt(ii) - b.flt(ii));
                }
                return Dec.get(a.dec(ii).subtract(b.dec(ii)));
            }
            if (ta == tb) {
                if (ta == AtomType.DTM || ta == AtomType.DAT || ta == AtomType.TIM) {
                    return new DTDur((ADate)a, (ADate)b, ii);
                }
                if (ta == AtomType.YMD) {
                    return new YMDur((YMDur)a, (YMDur)b, false, ii);
                }
                if (ta == AtomType.DTD) {
                    return new DTDur((DTDur)a, (DTDur)b, false, ii);
                }
                throw this.numError(ii, t1 ? b : a);
            }
            if (ta == AtomType.DTM) {
                return new Dtm((Dtm)a, this.checkDur(ii, b), false, ii);
            }
            if (ta == AtomType.DAT) {
                return new Dat((Dat)a, this.checkDur(ii, b), false, ii);
            }
            if (ta == AtomType.TIM && tb == AtomType.DTD) {
                return new Tim((Tim)a, (DTDur)b, false);
            }
            throw this.typeError(ii, ta, tb);
        }
    }
    ,
    MULT("*"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            boolean t2;
            Type ta = a.type;
            Type tb = b.type;
            if (ta == AtomType.YMD) {
                if (b instanceof ANum) {
                    return new YMDur((Dur)a, b.dbl(ii), true, ii);
                }
                throw this.numError(ii, b);
            }
            if (tb == AtomType.YMD) {
                if (a instanceof ANum) {
                    return new YMDur((Dur)b, a.dbl(ii), true, ii);
                }
                throw this.numError(ii, a);
            }
            if (ta == AtomType.DTD) {
                if (b instanceof ANum) {
                    return new DTDur((Dur)a, b.dbl(ii), true, ii);
                }
                throw this.numError(ii, b);
            }
            if (tb == AtomType.DTD) {
                if (a instanceof ANum) {
                    return new DTDur((Dur)b, a.dbl(ii), true, ii);
                }
                throw this.numError(ii, a);
            }
            boolean t1 = ta.isNumberOrUntyped();
            if (t1 ^ (t2 = tb.isNumberOrUntyped())) {
                throw this.typeError(ii, ta, tb);
            }
            if (t1 && t2) {
                Type t = 3.type(ta, tb);
                if (t == AtomType.ITR) {
                    long l1 = a.itr(ii);
                    long l2 = b.itr(ii);
                    if (l2 > 0L ? l1 > Long.MAX_VALUE / l2 || l1 < Long.MIN_VALUE / l2 : (l2 < -1L ? l1 > Long.MIN_VALUE / l2 || l1 < Long.MAX_VALUE / l2 : l2 == -1L && l1 == Long.MIN_VALUE)) {
                        throw Err.RANGE.get(ii, l1 + " * " + l2);
                    }
                    return Int.get(l1 * l2);
                }
                if (t == AtomType.DBL) {
                    return Dbl.get(a.dbl(ii) * b.dbl(ii));
                }
                if (t == AtomType.FLT) {
                    return Flt.get(a.flt(ii) * b.flt(ii));
                }
                return Dec.get(a.dec(ii).multiply(b.dec(ii)));
            }
            throw this.numError(ii, t1 ? b : a);
        }
    }
    ,
    DIV("div"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            Type ta = a.type;
            Type tb = b.type;
            if (ta == tb) {
                if (ta == AtomType.YMD) {
                    BigDecimal bd = BigDecimal.valueOf(((YMDur)b).ymd());
                    if (bd.doubleValue() == 0.0) {
                        throw Err.DIVZERO.get(ii, new Object[]{Err.chop(a)});
                    }
                    return Dec.get(BigDecimal.valueOf(((YMDur)a).ymd()).divide(bd, 20, 6));
                }
                if (ta == AtomType.DTD) {
                    BigDecimal bd = ((DTDur)b).dtd();
                    if (bd.doubleValue() == 0.0) {
                        throw Err.DIVZERO.get(ii, new Object[]{Err.chop(a)});
                    }
                    return Dec.get(((DTDur)a).dtd().divide(bd, 20, 6));
                }
            }
            if (ta == AtomType.YMD) {
                if (b instanceof ANum) {
                    return new YMDur((Dur)a, b.dbl(ii), false, ii);
                }
                throw this.numError(ii, b);
            }
            if (ta == AtomType.DTD) {
                if (b instanceof ANum) {
                    return new DTDur((Dur)a, b.dbl(ii), false, ii);
                }
                throw this.numError(ii, b);
            }
            this.checkNum(ii, a, b);
            Type t = 4.type(ta, tb);
            if (t == AtomType.DBL) {
                return Dbl.get(a.dbl(ii) / b.dbl(ii));
            }
            if (t == AtomType.FLT) {
                return Flt.get(a.flt(ii) / b.flt(ii));
            }
            BigDecimal b1 = a.dec(ii);
            BigDecimal b2 = b.dec(ii);
            if (b2.signum() == 0) {
                throw Err.DIVZERO.get(ii, new Object[]{Err.chop(a)});
            }
            int s = Math.max(18, Math.max(b1.scale(), b2.scale()));
            return Dec.get(b1.divide(b2, s, RoundingMode.HALF_EVEN));
        }
    }
    ,
    IDIV("idiv"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            this.checkNum(ii, a, b);
            Type t = 5.type(a.type, b.type);
            if (t == AtomType.DBL || t == AtomType.FLT) {
                double d1 = a.dbl(ii);
                double d2 = b.dbl(ii);
                if (d2 == 0.0) {
                    throw Err.DIVZERO.get(ii, new Object[]{Err.chop(a)});
                }
                double d = d1 / d2;
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    throw Err.DIVFLOW.get(ii, d1, d2);
                }
                if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                    throw Err.RANGE.get(ii, d1 + " idiv " + d2);
                }
                return Int.get((long)d);
            }
            if (t == AtomType.ITR) {
                long b1 = a.itr(ii);
                long b2 = b.itr(ii);
                if (b2 == 0L) {
                    throw Err.DIVZERO.get(ii, new Object[]{Err.chop(a)});
                }
                if (b1 == Integer.MIN_VALUE && b2 == -1L) {
                    throw Err.RANGE.get(ii, b1 + " idiv " + b2);
                }
                return Int.get(b1 / b2);
            }
            BigDecimal b1 = a.dec(ii);
            BigDecimal b2 = b.dec(ii);
            if (b2.signum() == 0) {
                throw Err.DIVZERO.get(ii, new Object[]{Err.chop(a)});
            }
            BigDecimal res = b1.divideToIntegralValue(b2);
            if (MIN_LONG.compareTo(res) > 0 || res.compareTo(MAX_LONG) > 0) {
                throw Err.RANGE.get(ii, b1 + " idiv " + b2);
            }
            return Int.get(res.longValueExact());
        }
    }
    ,
    MOD("mod"){

        @Override
        public Item ev(InputInfo ii, Item a, Item b) throws QueryException {
            this.checkNum(ii, a, b);
            Type t = 6.type(a.type, b.type);
            if (t == AtomType.DBL) {
                return Dbl.get(a.dbl(ii) % b.dbl(ii));
            }
            if (t == AtomType.FLT) {
                return Flt.get(a.flt(ii) % b.flt(ii));
            }
            if (t == AtomType.ITR) {
                long b1 = a.itr(ii);
                long b2 = b.itr(ii);
                if (b2 == 0L) {
                    throw Err.DIVZERO.get(ii, new Object[]{Err.chop(a)});
                }
                return Int.get(b1 % b2);
            }
            BigDecimal b1 = a.dec(ii);
            BigDecimal b2 = b.dec(ii);
            if (b2.signum() == 0) {
                throw Err.DIVZERO.get(ii, new Object[]{Err.chop(a)});
            }
            BigDecimal q = b1.divide(b2, 0, 1);
            return Dec.get(b1.subtract(q.multiply(b2)));
        }
    };

    private static final BigDecimal MIN_LONG;
    private static final BigDecimal MAX_LONG;
    final String name;

    private Calc(String n2) {
        this.name = n2;
    }

    public abstract Item ev(InputInfo var1, Item var2, Item var3) throws QueryException;

    public static Type type(Type a, Type b) {
        if (a == AtomType.DBL || b == AtomType.DBL || a.isUntyped() || b.isUntyped()) {
            return AtomType.DBL;
        }
        if (a == AtomType.FLT || b == AtomType.FLT) {
            return AtomType.FLT;
        }
        if (a == AtomType.DEC || b == AtomType.DEC) {
            return AtomType.DEC;
        }
        return AtomType.ITR;
    }

    final QueryException typeError(InputInfo ii, Type ta, Type tb) {
        return Err.CALCTYPE.get(ii, this.info(), ta, tb);
    }

    final QueryException numError(InputInfo ii, Item it) {
        return Err.NONUMBER.get(ii, this.info(), it.type);
    }

    final Dur checkDur(InputInfo ii, Item it) throws QueryException {
        Type ip = it.type;
        if (!(it instanceof Dur)) {
            throw Err.NODUR.get(ii, this.info(), ip);
        }
        if (ip == AtomType.DUR) {
            throw Err.NOSUBDUR.get(ii, this.info(), it);
        }
        return (Dur)it;
    }

    final void checkNum(InputInfo ii, Item a, Item b) throws QueryException {
        if (!a.type.isNumberOrUntyped()) {
            throw this.numError(ii, a);
        }
        if (!b.type.isNumberOrUntyped()) {
            throw this.numError(ii, b);
        }
    }

    final String info() {
        return '\'' + this.name + "' operator";
    }

    public String toString() {
        return this.name;
    }

    static {
        MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
        MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
    }
}

