/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.Expr;
import org.basex.query.util.Collation;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class CmpN
extends Cmp {
    private final OpN op;

    public CmpN(Expr e1, Expr e2, OpN o, InputInfo ii) {
        super(ii, e1, e2, (Collation)null);
        this.op = o;
        this.type = SeqType.BLN_ZO;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        this.type = SeqType.get((Type)AtomType.BLN, this.expr[0].size() == 1L && this.expr[1].size() == 1L ? SeqType.Occ.ONE : SeqType.Occ.ZERO_ONE);
        return this.optPre(this.oneIsEmpty() ? null : (this.allAreValues() ? this.item(ctx, this.info) : this), ctx);
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item a = this.expr[0].item(ctx, this.info);
        if (a == null) {
            return null;
        }
        Item b = this.expr[1].item(ctx, this.info);
        if (b == null) {
            return null;
        }
        return Bln.get(this.op.eval(this.checkNode(a), this.checkNode(b)));
    }

    @Override
    public CmpN invert() {
        throw Util.notExpected(new Object[0]);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new CmpN(this.expr[0].copy(ctx, scp, vs), this.expr[1].copy(ctx, scp, vs), this.op, this.info);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.OP, this.op.name), this.expr);
    }

    @Override
    public String description() {
        return "'" + (Object)((Object)this.op) + "' operator";
    }

    @Override
    public String toString() {
        return this.toString(" " + (Object)((Object)this.op) + ' ');
    }

    public static enum OpN {
        EQ("is"){

            @Override
            public boolean eval(ANode a, ANode b) {
                return a.is(b);
            }
        }
        ,
        ET("<<"){

            @Override
            public boolean eval(ANode a, ANode b) {
                return a.diff(b) < 0;
            }
        }
        ,
        GT(">>"){

            @Override
            public boolean eval(ANode a, ANode b) {
                return a.diff(b) > 0;
            }
        };

        public static final OpN[] VALUES;
        public final String name;

        private OpN(String n2) {
            this.name = n2;
        }

        public abstract boolean eval(ANode var1, ANode var2);

        public String toString() {
            return this.name;
        }

        static {
            VALUES = OpN.values();
        }
    }
}

