/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Pos;
import org.basex.query.func.Function;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CmpV
extends Cmp {
    OpV op;

    public CmpV(Expr e1, Expr e2, OpV o, Collation coll, InputInfo ii) {
        super(ii, e1, e2, coll);
        this.op = o;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        super.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.swap()) {
            this.op = this.op.swap();
            ctx.compInfo("swapping operands: %", this);
        }
        Expr e1 = this.expr[0];
        Expr e2 = this.expr[1];
        this.type = SeqType.get((Type)AtomType.BLN, e1.size() == 1L && e2.size() == 1L ? SeqType.Occ.ONE : SeqType.Occ.ZERO_ONE);
        Expr e = this;
        if (this.oneIsEmpty()) {
            e = this.optPre(null, ctx);
        } else if (this.allAreValues()) {
            e = this.preEval(ctx);
        } else if (e1.isFunction(Function.COUNT)) {
            e = this.compCount(this.op);
            if (e != this) {
                ctx.compInfo(e instanceof Bln ? "pre-evaluating %" : "rewriting %", this);
            }
        } else if (e1.isFunction(Function.POSITION)) {
            if ((e = Pos.get(this.op, e2, e, this.info)) != this) {
                ctx.compInfo("rewriting %", this);
            }
        } else if (e1.type().eq(SeqType.BLN) && (this.op == OpV.EQ && e2 == Bln.FALSE || this.op == OpV.NE && e2 == Bln.TRUE)) {
            e = Function.NOT.get(null, this.info, e1);
        }
        return e;
    }

    @Override
    public Expr compEbv(QueryContext ctx) {
        return (this.op == OpV.EQ && this.expr[1] == Bln.TRUE || this.op == OpV.NE && this.expr[1] == Bln.FALSE) && this.expr[0].type().eq(SeqType.BLN) ? this.expr[0] : this;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item a = this.expr[0].item(ctx, this.info);
        if (a == null) {
            return null;
        }
        Item b = this.expr[1].item(ctx, this.info);
        if (b == null) {
            return null;
        }
        if (a.comparable(b)) {
            return Bln.get(this.op.eval(a, b, this.collation, this.info));
        }
        if (a instanceof FItem) {
            throw Err.FIEQ.get(this.info, a.type);
        }
        if (b instanceof FItem) {
            throw Err.FIEQ.get(this.info, b.type);
        }
        throw Err.INVTYPECMP.get(this.info, a.type, b.type);
    }

    @Override
    public CmpV invert() {
        return this.expr[0].size() != 1L || this.expr[1].size() != 1L ? this : new CmpV(this.expr[0], this.expr[1], this.op.invert(), this.collation, this.info);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Expr a = this.expr[0].copy(ctx, scp, vs);
        Expr b = this.expr[1].copy(ctx, scp, vs);
        return new CmpV(a, b, this.op, this.collation, this.info);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.OP, this.op.name), this.expr);
    }

    @Override
    public String description() {
        return "'" + (Object)((Object)this.op) + "' operator";
    }

    @Override
    public String toString() {
        return this.toString(" " + (Object)((Object)this.op) + ' ');
    }

    public static enum OpV {
        LE("le"){

            @Override
            public boolean eval(Item a, Item b, Collation coll, InputInfo ii) throws QueryException {
                int v = a.diff(b, coll, ii);
                return v != Integer.MIN_VALUE && v <= 0;
            }

            @Override
            public OpV swap() {
                return GE;
            }

            @Override
            public OpV invert() {
                return GT;
            }
        }
        ,
        LT("lt"){

            @Override
            public boolean eval(Item a, Item b, Collation coll, InputInfo ii) throws QueryException {
                int v = a.diff(b, coll, ii);
                return v != Integer.MIN_VALUE && v < 0;
            }

            @Override
            public OpV swap() {
                return GT;
            }

            @Override
            public OpV invert() {
                return GE;
            }
        }
        ,
        GE("ge"){

            @Override
            public boolean eval(Item a, Item b, Collation coll, InputInfo ii) throws QueryException {
                int v = a.diff(b, coll, ii);
                return v != Integer.MIN_VALUE && v >= 0;
            }

            @Override
            public OpV swap() {
                return LE;
            }

            @Override
            public OpV invert() {
                return LT;
            }
        }
        ,
        GT("gt"){

            @Override
            public boolean eval(Item a, Item b, Collation coll, InputInfo ii) throws QueryException {
                int v = a.diff(b, coll, ii);
                return v != Integer.MIN_VALUE && v > 0;
            }

            @Override
            public OpV swap() {
                return LT;
            }

            @Override
            public OpV invert() {
                return LE;
            }
        }
        ,
        EQ("eq"){

            @Override
            public boolean eval(Item a, Item b, Collation coll, InputInfo ii) throws QueryException {
                return a.eq(b, coll, ii);
            }

            @Override
            public OpV swap() {
                return EQ;
            }

            @Override
            public OpV invert() {
                return NE;
            }
        }
        ,
        NE("ne"){

            @Override
            public boolean eval(Item a, Item b, Collation coll, InputInfo ii) throws QueryException {
                return !a.eq(b, coll, ii);
            }

            @Override
            public OpV swap() {
                return NE;
            }

            @Override
            public OpV invert() {
                return EQ;
            }
        };

        public static final OpV[] VALUES;
        public final String name;

        private OpV(String n2) {
            this.name = n2;
        }

        public abstract boolean eval(Item var1, Item var2, Collation var3, InputInfo var4) throws QueryException;

        public abstract OpV swap();

        public abstract OpV invert();

        public String toString() {
            return this.name;
        }

        static {
            VALUES = OpV.values();
        }
    }
}

