/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.core.Perm;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ParseExpr
extends Expr {
    public final InputInfo info;
    public SeqType type;
    protected long size = -1L;

    protected ParseExpr(InputInfo ii) {
        this.info = ii;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Item it = this.item(ctx, this.info);
        return it != null ? it.iter() : Empty.ITER;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Iter ir = this.iter(ctx);
        Item it = ir.next();
        if (it == null || ir.size() == 1L) {
            return it;
        }
        Item n = ir.next();
        if (n != null) {
            ValueBuilder vb = new ValueBuilder().add(it).add(n);
            n = ir.next();
            if (n != null) {
                vb.add(Str.get("..."));
            }
            throw Err.SEQCAST.get(ii, vb.value());
        }
        return it;
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        if (this.type().zeroOrOne()) {
            Item v = this.item(ctx, this.info);
            return v == null ? Empty.SEQ : v;
        }
        return ctx.iter(this).value();
    }

    protected final <T extends ParseExpr> T copyType(T e) {
        e.type = this.type;
        e.size = this.size;
        return e;
    }

    @Override
    public final Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it;
        if (this.type().zeroOrOne()) {
            it = this.item(ctx, this.info);
        } else {
            Iter ir = this.iter(ctx);
            it = ir.next();
            if (it != null && !(it instanceof ANode) && ir.next() != null) {
                throw Err.CONDTYPE.get(this.info, this);
            }
        }
        return it == null ? Bln.FALSE : it;
    }

    @Override
    public final Item test(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.ebv(ctx, this.info);
        return (it instanceof ANum ? it.dbl(this.info) == (double)ctx.pos : it.bool(this.info)) ? it : null;
    }

    @Override
    public SeqType type() {
        return this.type != null ? this.type : SeqType.ITEM_ZM;
    }

    @Override
    public final long size() {
        return this.size == -1L ? this.type().occ() : this.size;
    }

    protected final Expr preEval(QueryContext ctx) throws QueryException {
        return this.optPre(this.item(ctx, this.info), ctx);
    }

    protected final Expr optPre(Expr opt, QueryContext ctx) {
        if (opt != this) {
            ctx.compInfo("pre-evaluating %", this);
        }
        return opt == null ? Empty.SEQ : opt;
    }

    protected static Expr compBln(Expr e, InputInfo ii) {
        return e.type().eq(SeqType.BLN) ? e : Function.BOOLEAN.get(null, ii, e);
    }

    protected void checkNoUp(Expr expr) throws QueryException {
        if (expr == null) {
            return;
        }
        expr.checkUp();
        if (expr.has(Expr.Flag.UPD)) {
            throw Err.UPNOT.get(this.info, this.description());
        }
    }

    protected final void checkNoneUp(Expr ... expr) throws QueryException {
        if (expr == null) {
            return;
        }
        this.checkAllUp(expr);
        for (Expr e : expr) {
            if (e == null || !e.has(Expr.Flag.UPD)) continue;
            throw Err.UPNOT.get(this.info, this.description());
        }
    }

    void checkAllUp(Expr ... expr) throws QueryException {
        int s = 0;
        for (Expr e : expr) {
            e.checkUp();
            if (e.isVacuous()) continue;
            boolean u = e.has(Expr.Flag.UPD);
            if (u && s == -1 || !u && s == 1) {
                throw Err.UPALL.get(this.info, this.description());
            }
            s = u ? 1 : -1;
        }
    }

    protected final boolean checkBln(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkNoEmpty(e.item(ctx, this.info), AtomType.BLN);
        Type ip = it.type;
        if (ip == AtomType.BLN || ip.isUntyped()) {
            return it.bool(this.info);
        }
        throw Err.INVCAST.get(this.info, it.type, AtomType.BLN);
    }

    protected final double checkDbl(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkNoEmpty(e.item(ctx, this.info), AtomType.DBL);
        if (it.type.isNumberOrUntyped()) {
            return it.dbl(this.info);
        }
        throw Err.numberError(this, it);
    }

    protected final float checkFlt(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkNoEmpty(e.item(ctx, this.info), AtomType.FLT);
        if (it.type.isNumberOrUntyped()) {
            return it.flt(this.info);
        }
        throw Err.numberError(this, it);
    }

    protected final long checkItr(Expr e, QueryContext ctx) throws QueryException {
        return this.checkItr(this.checkNoEmpty(e.item(ctx, this.info), AtomType.ITR));
    }

    protected final long checkItr(Item it) throws QueryException {
        Type ip = it.type;
        if (ip.instanceOf(AtomType.ITR) || ip.isUntyped()) {
            return it.itr(this.info);
        }
        throw Err.INVCAST.get(this.info, it.type, AtomType.ITR);
    }

    protected final ANode checkNode(Expr e, QueryContext ctx) throws QueryException {
        return this.checkNode(this.checkItem(e, ctx));
    }

    protected final ANode checkNode(Item it) throws QueryException {
        if (it instanceof ANode) {
            return (ANode)it;
        }
        throw Err.INVCAST.get(this.info, it.type, NodeType.NOD);
    }

    protected final DBNode checkDBNode(Item it) throws QueryException {
        if (it instanceof DBNode) {
            return (DBNode)it;
        }
        throw Err.BXDB_NODB.get(this.info, this);
    }

    protected final Collation checkColl(Expr e, QueryContext ctx, StaticContext sc) throws QueryException {
        return Collation.get(e == null ? null : this.checkStr(e, ctx), ctx, sc, this.info, Err.WHICHCOLL);
    }

    protected final byte[] checkStr(Expr e, QueryContext ctx) throws QueryException {
        return this.checkStr(this.checkItem(e, ctx));
    }

    protected final byte[] checkStr(Item it) throws QueryException {
        Type ip = it.type;
        if (ip.isStringOrUntyped()) {
            return it.string(this.info);
        }
        throw Err.INVCAST.get(this.info, it.type, AtomType.STR);
    }

    protected final byte[] checkEStr(Item it) throws QueryException {
        if (it == null) {
            return Token.EMPTY;
        }
        Type ip = it.type;
        if (ip.isStringOrUntyped()) {
            return it.string(this.info);
        }
        throw it instanceof FItem ? Err.FIATOM.get(this.info, ip) : Err.INVCAST.get(this.info, it.type, AtomType.STR);
    }

    protected final Value checkCtx(QueryContext ctx) throws QueryException {
        Value v = ctx.value;
        if (v != null) {
            return v;
        }
        throw Err.NOCTX.get(this.info, this);
    }

    protected final ANode checkNode(QueryContext ctx) throws QueryException {
        Value v = ctx.value;
        if (v == null) {
            throw Err.NOCTX.get(this.info, this);
        }
        if (v instanceof ANode) {
            return (ANode)v;
        }
        throw Err.STEPNODE.get(this.info, this, v.type);
    }

    protected final Item checkItem(Expr e, QueryContext ctx) throws QueryException {
        return this.checkNoEmpty(e.item(ctx, this.info));
    }

    protected final Bin checkBinary(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkItem(e, ctx);
        if (it instanceof Bin) {
            return (Bin)it;
        }
        throw Err.BINARYTYPE.get(this.info, it.type);
    }

    protected final byte[] checkStrBin(Item it) throws QueryException {
        if (it instanceof AStr) {
            return it.string(this.info);
        }
        if (it instanceof Bin) {
            return ((Bin)it).binary(this.info);
        }
        throw Err.STRBINTYPE.get(this.info, it.type);
    }

    protected final QNm checkQNm(Expr e, QueryContext ctx, StaticContext sc) throws QueryException {
        Item it = this.checkItem(e, ctx);
        if (it.type == AtomType.QNM) {
            return (QNm)it;
        }
        if (it.type.isUntyped() && sc.xquery3()) {
            throw Err.NSSENS.get(this.info, it.type, AtomType.QNM);
        }
        throw Err.INVCAST.get(this.info, it.type, AtomType.QNM);
    }

    protected FItem checkFunc(Expr e, QueryContext ctx) throws QueryException {
        return (FItem)this.checkType(this.checkItem(e, ctx), FuncType.ANY_FUN);
    }

    protected final Item checkType(Item it, Type t) throws QueryException {
        if (this.checkNoEmpty((Item)it, (Type)t).type.instanceOf(t)) {
            return it;
        }
        throw Err.INVCAST.get(this.info, it.type, t);
    }

    protected final Item checkNoEmpty(Item it) throws QueryException {
        if (it != null) {
            return it;
        }
        throw Err.INVEMPTY.get(this.info, this.description());
    }

    private Item checkNoEmpty(Item it, Type t) throws QueryException {
        if (it != null) {
            return it;
        }
        throw Err.INVEMPTYEX.get(this.info, this.description(), t);
    }

    protected final byte[] checkEStr(Expr e, QueryContext ctx) throws QueryException {
        return this.checkEStr(e.item(ctx, this.info));
    }

    protected final void checkAdmin(QueryContext ctx) throws QueryException {
        this.checkPerm(ctx, Perm.ADMIN);
    }

    protected final void checkCreate(QueryContext ctx) throws QueryException {
        this.checkPerm(ctx, Perm.CREATE);
    }

    private void checkPerm(QueryContext ctx, Perm p) throws QueryException {
        if (!ctx.context.user.has(p)) {
            throw Err.BASX_PERM.get(this.info, new Object[]{p});
        }
    }

    protected Map checkMap(Item it) throws QueryException {
        if (it instanceof Map) {
            return (Map)it;
        }
        throw Err.INVCAST.get(this.info, it.type, SeqType.ANY_MAP);
    }
}

