/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.StringToken;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IndexAccess;
import org.basex.query.expr.Union;
import org.basex.query.func.Function;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.IndexContext;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class ValueAccess
extends IndexAccess {
    private Expr expr;
    final IndexType itype;

    public ValueAccess(InputInfo ii, Expr e, IndexType t, IndexContext ic) {
        super(ic, ii);
        this.expr = e;
        this.itype = t;
    }

    @Override
    public NodeIter iter(QueryContext ctx) throws QueryException {
        Item it;
        Iter[] iter = new NodeIter[]{};
        Iter ir = ctx.iter(this.expr);
        while ((it = ir.next()) != null) {
            int s = iter.length;
            NodeIter[] tmp = new NodeIter[s + 1];
            System.arraycopy(iter, 0, tmp, 0, s);
            iter = tmp;
            iter[s] = this.index(it.string(this.info));
        }
        return iter.length == 0 ? AxisMoreIter.EMPTY : (iter.length == 1 ? iter[0] : new Union(this.info, this.expr).eval(iter));
    }

    private AxisIter index(byte[] term) {
        final Data data = this.ictx.data;
        final IndexIterator ii = term.length <= data.meta.maxlen && (this.itype == IndexType.TEXT ? data.meta.textindex : data.meta.attrindex) ? data.iter(new StringToken(this.itype, term)) : this.scan(term);
        return new AxisIter(){
            final byte kind;
            {
                this.kind = (byte)(ValueAccess.this.itype == IndexType.TEXT ? 2 : 3);
            }

            @Override
            public ANode next() {
                return ii.more() ? new DBNode(data, ii.pre(), this.kind) : null;
            }
        };
    }

    private IndexIterator scan(final byte[] val) {
        return new IndexIterator(){
            final Data data;
            final boolean text;
            final byte kind;
            int pre;
            {
                this.data = ValueAccess.this.ictx.data;
                this.text = ValueAccess.this.itype == IndexType.TEXT;
                this.kind = (byte)(this.text ? 2 : 3);
                this.pre = -1;
            }

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.data.meta.size) {
                    if (this.data.kind(this.pre) != this.kind || !Token.eq(this.data.text(this.pre, this.text), val)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                return Math.max(1, this.data.meta.size >>> 1);
            }
        };
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.expr.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        return this.expr.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.expr.count(v);
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        Expr sub = this.expr.inline(ctx, scp, v, e);
        if (sub == null) {
            return null;
        }
        this.expr = sub;
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new ValueAccess(this.info, this.expr.copy(ctx, scp, vs), this.itype, this.ictx);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[]{QueryText.DATA, this.ictx.data.meta.name, QueryText.TYP, this.itype}), this.expr);
    }

    @Override
    public String toString() {
        return (this.itype == IndexType.TEXT ? Function._DB_TEXT : Function._DB_ATTRIBUTE).get(null, this.info, Str.get(this.ictx.data.meta.name), this.expr).toString();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize() + 1;
    }
}

