/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class FTExpr
extends ParseExpr {
    public final FTExpr[] expr;

    FTExpr(InputInfo ii, FTExpr ... e) {
        super(ii);
        this.expr = e;
        this.type = SeqType.BLN;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.expr);
    }

    @Override
    public FTExpr compile(QueryContext ctx, VarScope scp) throws QueryException {
        int es = this.expr.length;
        for (int e = 0; e < es; ++e) {
            this.expr[e] = this.expr[e].compile(ctx, scp);
        }
        return this;
    }

    @Override
    public FTExpr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        return this;
    }

    @Override
    public abstract FTNode item(QueryContext var1, InputInfo var2) throws QueryException;

    @Override
    public abstract FTIter iter(QueryContext var1) throws QueryException;

    @Override
    public boolean has(Expr.Flag flag) {
        for (FTExpr e : this.expr) {
            if (!e.has(flag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removable(Var v) {
        for (FTExpr e : this.expr) {
            if (((Expr)e).removable(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var v) {
        return VarUsage.sum(v, this.expr);
    }

    @Override
    public FTExpr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        return FTExpr.inlineAll(ctx, scp, this.expr, v, e) ? this.optimize(ctx, scp) : null;
    }

    @Override
    public abstract FTExpr copy(QueryContext var1, VarScope var2, IntObjMap<Var> var3);

    @Override
    public FTExpr indexEquivalent(IndexCosts ic) throws QueryException {
        int es = this.expr.length;
        for (int e = 0; e < es; ++e) {
            this.expr[e] = this.expr[e].indexEquivalent(ic);
        }
        return this;
    }

    boolean usesExclude() {
        for (FTExpr e : this.expr) {
            if (!e.usesExclude()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), this.expr);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return FTExpr.visitAll(visitor, this.expr);
    }

    @Override
    public int exprSize() {
        int sz = 1;
        for (FTExpr e : this.expr) {
            sz += ((Expr)e).exprSize();
        }
        return sz;
    }

    final String toString(Object sep) {
        StringBuilder sb = new StringBuilder();
        int es = this.expr.length;
        for (int e = 0; e < es; ++e) {
            sb.append(e == 0 ? "" : sep.toString()).append(this.expr[e]);
        }
        return sb.toString();
    }
}

