/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import org.basex.build.CsvOptions;
import org.basex.build.CsvParserOptions;
import org.basex.io.IOContent;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public class FNCsv
extends StandardFunc {
    private static final QNm Q_OPTIONS = QNm.get("csv:options", QueryText.CSVURI);

    public FNCsv(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _CSV_PARSE: {
                return this.parse(ctx);
            }
            case _CSV_SERIALIZE: {
                return this.serialize(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item parse(QueryContext ctx) throws QueryException {
        byte[] input = this.checkStr(this.expr[0], ctx);
        CsvParserOptions opts = this.checkOptions(1, Q_OPTIONS, new CsvParserOptions(), ctx);
        try {
            CsvConverter conv = CsvConverter.get(opts);
            conv.convert(new IOContent(input));
            return conv.finish();
        }
        catch (IOException ex) {
            throw Err.BXCS_PARSE.get(this.info, ex);
        }
    }

    private Str serialize(QueryContext ctx) throws QueryException {
        Iter iter = ctx.iter(this.expr[0]);
        CsvOptions copts = this.checkOptions(1, Q_OPTIONS, new CsvOptions(), ctx);
        SerializerOptions sopts = new SerializerOptions();
        sopts.set(SerializerOptions.METHOD, SerialMethod.CSV);
        sopts.set(SerializerOptions.CSV, copts);
        return Str.get(Token.delete(this.serialize(iter, sopts, Err.INVALIDOPT), 13));
    }
}

