/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import java.util.Comparator;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.StaticContext;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.XQFunction;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.MinHeap;

public final class FNHof
extends StandardFunc {
    public FNHof(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _HOF_SORT_WITH: {
                return this.sortWith(ctx).iter();
            }
            case _HOF_ID: 
            case _HOF_CONST: {
                return ctx.iter(this.expr[0]);
            }
            case _HOF_FOLD_LEFT1: {
                return this.foldLeft1(ctx).iter();
            }
            case _HOF_UNTIL: {
                return this.until(ctx).iter();
            }
            case _HOF_TOP_K_BY: {
                return this.topKBy(ctx).iter();
            }
            case _HOF_TOP_K_WITH: {
                return this.topKWith(ctx).iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _HOF_SORT_WITH: {
                return this.sortWith(ctx);
            }
            case _HOF_FOLD_LEFT1: {
                return this.foldLeft1(ctx);
            }
            case _HOF_UNTIL: {
                return this.until(ctx);
            }
            case _HOF_ID: 
            case _HOF_CONST: {
                return ctx.value(this.expr[0]);
            }
            case _HOF_TOP_K_BY: {
                return this.topKBy(ctx);
            }
            case _HOF_TOP_K_WITH: {
                return this.topKWith(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _HOF_ID: 
            case _HOF_CONST: {
                return this.expr[0].item(ctx, ii);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    protected Expr opt(QueryContext ctx, VarScope scp) throws QueryException {
        switch (this.sig) {
            case _HOF_ID: 
            case _HOF_CONST: {
                return this.expr[0];
            }
            case _HOF_FOLD_LEFT1: {
                if (this.allAreValues() && this.expr[0].size() < 10L) {
                    ctx.compInfo("unrolling %", this);
                    Value seq = (Value)this.expr[0];
                    if (seq.isEmpty()) {
                        throw Err.INVEMPTY.get(this.info, this.description());
                    }
                    FItem f = this.withArity(1, 2, ctx);
                    Expr e = seq.itemAt(0L);
                    int len = (int)seq.size();
                    for (int i = 1; i < len; ++i) {
                        e = new DynFuncCall(this.info, false, (Expr)f, e, seq.itemAt(i)).optimize(ctx, scp);
                    }
                    return e;
                }
                return this;
            }
        }
        return this;
    }

    private Value foldLeft1(QueryContext ctx) throws QueryException {
        Item x;
        FItem f = this.withArity(1, 2, ctx);
        Iter xs = this.expr[0].iter(ctx);
        Value sum = this.checkNoEmpty(xs.next());
        while ((x = xs.next()) != null) {
            sum = f.invokeValue(ctx, this.info, sum, x);
        }
        return sum;
    }

    private Value sortWith(QueryContext ctx) throws QueryException {
        Value v = this.expr[0].value(ctx);
        Comparator<Item> cmp = this.getComp(1, ctx);
        if (v.size() < 2L) {
            return v;
        }
        ValueBuilder vb = v.cache();
        try {
            Arrays.sort(vb.items(), 0, (int)vb.size(), cmp);
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        return vb.value();
    }

    private Value until(QueryContext ctx) throws QueryException {
        FItem pred = this.withArity(0, 1, ctx);
        FItem fun = this.withArity(1, 1, ctx);
        Value v = ctx.value(this.expr[2]);
        while (!this.checkBln(this.checkNoEmpty(pred.invokeItem(ctx, this.info, v)), ctx)) {
            v = fun.invokeValue(ctx, this.info, v);
        }
        return v;
    }

    private Value topKBy(QueryContext ctx) throws QueryException {
        FItem getKey = this.withArity(1, 1, ctx);
        long k = this.checkItr(this.expr[2], ctx);
        if (k < 1L || k > 0x3FFFFFFFL) {
            return Empty.SEQ;
        }
        Iter iter = this.expr[0].iter(ctx);
        MinHeap<Item, Item> heap = new MinHeap<Item, Item>((int)k, new Comparator<Item>(){

            @Override
            public int compare(Item it1, Item it2) {
                try {
                    return CmpV.OpV.LT.eval(it1, it2, FNHof.this.sc.collation, FNHof.this.info) ? -1 : 1;
                }
                catch (QueryException qe) {
                    throw new QueryRTException(qe);
                }
            }
        });
        try {
            Item it;
            while ((it = iter.next()) != null) {
                heap.insert(this.checkNoEmpty(getKey.invokeItem(ctx, this.info, it)), it);
                if ((long)heap.size() <= k) continue;
                heap.removeMin();
            }
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        Item[] arr = new Item[heap.size()];
        int i = arr.length;
        while (--i >= 0) {
            arr[i] = (Item)heap.removeMin();
        }
        return Seq.get(arr, arr.length);
    }

    private Value topKWith(QueryContext ctx) throws QueryException {
        Comparator<Item> cmp = this.getComp(1, ctx);
        long k = this.checkItr(this.expr[2], ctx);
        if (k < 1L || k > 0x3FFFFFFFL) {
            return Empty.SEQ;
        }
        Iter iter = this.expr[0].iter(ctx);
        MinHeap<Item, Item> heap = new MinHeap<Item, Item>((int)k, cmp);
        try {
            Item it;
            while ((it = iter.next()) != null) {
                heap.insert(it, it);
                if ((long)heap.size() <= k) continue;
                heap.removeMin();
            }
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        Item[] arr = new Item[heap.size()];
        int i = arr.length;
        while (--i >= 0) {
            arr[i] = (Item)heap.removeMin();
        }
        return Seq.get(arr, arr.length);
    }

    private Comparator<Item> getComp(int pos, final QueryContext ctx) throws QueryException {
        final FItem lt = this.withArity(pos, 2, ctx);
        return new Comparator<Item>(){

            @Override
            public int compare(Item a, Item b) {
                try {
                    return FNHof.this.checkType(lt.invokeItem(ctx, FNHof.this.info, a == null ? Empty.SEQ : a, b == null ? Empty.SEQ : b), AtomType.BLN).bool(FNHof.this.info) ? -1 : 1;
                }
                catch (QueryException qe) {
                    throw new QueryRTException(qe);
                }
            }
        };
    }

    private FItem withArity(int p, int a, QueryContext ctx) throws QueryException {
        Item f = this.checkItem(this.expr[p], ctx);
        if (f instanceof FItem && ((XQFunction)((Object)f)).arity() == a) {
            return (FItem)f;
        }
        throw Err.typeError(this, FuncType.arity(a), f);
    }
}

