/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FNOut
extends StandardFunc {
    private static final Str NL = Str.get("\n");
    private static final Str TAB = Str.get("\t");

    public FNOut(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _OUT_NL: {
                return NL;
            }
            case _OUT_TAB: {
                return TAB;
            }
            case _OUT_FORMAT: {
                return this.format(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Str format(QueryContext ctx) throws QueryException {
        String form = Token.string(this.checkStr(this.expr[0], ctx));
        int es = this.expr.length;
        Object[] args = new Object[es - 1];
        for (int e = 1; e < es; ++e) {
            Item it = this.expr[e].item(ctx, this.info);
            args[e - 1] = it.type.isUntyped() ? Token.string(it.string(this.info)) : it.toJava();
        }
        try {
            return Str.get(String.format(form, args));
        }
        catch (RuntimeException ex) {
            throw Err.ERRFORM.get(this.info, Util.className(ex), ex);
        }
    }
}

