/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.regex.parse.RegExParser;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public final class FNPat
extends StandardFunc {
    private final TokenObjMap<Pattern> patterns = new TokenObjMap();
    private static final Pattern SLASH = Pattern.compile("\\$");
    private static final Pattern BSLASH = Pattern.compile("\\\\");
    private static final String PREFIX = "fn";
    private static final QNm Q_ANALYZE = QNm.get("fn", "analyze-string-result", QueryText.FNURI);
    private static final QNm Q_MATCH = QNm.get("fn", "match", QueryText.FNURI);
    private static final QNm Q_NONMATCH = QNm.get("fn", "non-match", QueryText.FNURI);
    private static final QNm Q_MGROUP = QNm.get("fn", "group", QueryText.FNURI);
    private static final String NR = "nr";

    public FNPat(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case TOKENIZE: {
                return this.tokenize(ctx).iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case TOKENIZE: {
                return this.tokenize(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case MATCHES: {
                return this.matches(this.checkEStr(this.expr[0], ctx), ctx);
            }
            case REPLACE: {
                return this.replace(this.checkEStr(this.expr[0], ctx), ctx);
            }
            case ANALYZE_STRING: {
                return this.analyzeString(this.checkEStr(this.expr[0], ctx), ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item matches(byte[] val, QueryContext ctx) throws QueryException {
        Pattern p = this.pattern(this.expr[1], this.expr.length == 3 ? this.expr[2] : null, ctx);
        return Bln.get(p.matcher(Token.string(val)).find());
    }

    private Item analyzeString(byte[] val, QueryContext ctx) throws QueryException {
        Pattern p = this.pattern(this.expr[1], this.expr.length == 3 ? this.expr[2] : null, ctx);
        if (p.matcher("").matches()) {
            throw Err.REGROUP.get(this.info, new Object[0]);
        }
        String str = Token.string(val);
        Matcher m = p.matcher(str);
        FElem root = new FElem(Q_ANALYZE).declareNS();
        int s = 0;
        while (m.find()) {
            if (s != m.start()) {
                FNPat.nonmatch(str.substring(s, m.start()), root);
            }
            FNPat.match(m, str, root, 0);
            s = m.end();
        }
        if (s != str.length()) {
            FNPat.nonmatch(str.substring(s), root);
        }
        return root;
    }

    private static int[] match(Matcher m, String str, FElem par, int g) {
        FElem nd = new FElem(g == 0 ? Q_MATCH : Q_MGROUP);
        if (g > 0) {
            nd.add(NR, Token.token(g));
        }
        int start = m.start(g);
        int end = m.end(g);
        int gc = m.groupCount();
        int[] pos = new int[]{g + 1, start};
        while (pos[0] <= gc && m.end(pos[0]) <= end) {
            int st = m.start(pos[0]);
            if (st >= 0) {
                if (pos[1] < st) {
                    nd.add(str.substring(pos[1], st));
                }
                pos = FNPat.match(m, str, nd, pos[0]);
                continue;
            }
            pos[0] = pos[0] + 1;
        }
        if (pos[1] < end) {
            nd.add(str.substring(pos[1], end));
            pos[1] = end;
        }
        par.add(nd);
        return pos;
    }

    private static void nonmatch(String text, FElem par) {
        par.add(new FElem(Q_NONMATCH).add(text));
    }

    private Item replace(byte[] val, QueryContext ctx) throws QueryException {
        byte[] rep = this.checkStr(this.expr[2], ctx);
        for (int i = 0; i < rep.length; ++i) {
            if (rep[i] == 92) {
                if (i + 1 == rep.length || rep[i + 1] != 92 && rep[i + 1] != 36) {
                    throw Err.FUNREPBS.get(this.info, new Object[0]);
                }
                ++i;
            }
            if (rep[i] != 36 || i != 0 && rep[i - 1] == 92 || i + 1 != rep.length && Token.digit(rep[i + 1])) continue;
            throw Err.FUNREPDOL.get(this.info, new Object[0]);
        }
        Pattern p = this.pattern(this.expr[1], this.expr.length == 4 ? this.expr[3] : null, ctx);
        if (p.pattern().isEmpty()) {
            throw Err.REGROUP.get(this.info, new Object[0]);
        }
        String r = Token.string(rep);
        if ((p.flags() & 0x10) != 0) {
            r = SLASH.matcher(BSLASH.matcher(r).replaceAll("\\\\\\\\")).replaceAll("\\\\\\$");
        }
        try {
            return Str.get(p.matcher(Token.string(val)).replaceAll(r));
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("No group")) {
                throw Err.REGROUP.get(this.info, new Object[0]);
            }
            throw Err.REGPAT.get(this.info, ex);
        }
    }

    private Value tokenize(QueryContext ctx) throws QueryException {
        byte[] val = this.checkEStr(this.expr[0], ctx);
        Pattern p = this.pattern(this.expr[1], this.expr.length == 3 ? this.expr[2] : null, ctx);
        if (p.matcher("").matches()) {
            throw Err.REGROUP.get(this.info, new Object[0]);
        }
        TokenList tl = new TokenList();
        String str = Token.string(val);
        if (!str.isEmpty()) {
            Matcher m = p.matcher(str);
            int s = 0;
            while (m.find()) {
                tl.add(str.substring(s, m.start()));
                s = m.end();
            }
            tl.add(str.substring(s, str.length()));
        }
        return StrSeq.get(tl);
    }

    private Pattern pattern(Expr pattern, Expr modifier, QueryContext ctx) throws QueryException {
        byte[] key;
        Pattern p;
        byte[] pat = this.checkStr(pattern, ctx);
        byte[] mod = modifier != null ? this.checkStr(modifier, ctx) : null;
        TokenBuilder tb = new TokenBuilder(pat);
        if (mod != null) {
            tb.add(0).add(mod);
        }
        if ((p = this.patterns.get(key = tb.finish())) == null) {
            p = RegExParser.parse(pat, mod, this.sc.xquery3(), this.info);
            this.patterns.put(key, p);
        }
        return p;
    }
}

