/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNInfo;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;

public final class FNProf
extends StandardFunc {
    public FNProf(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _PROF_MEM: {
                return this.mem(ctx);
            }
            case _PROF_TIME: {
                return this.time(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _PROF_SLEEP: {
                return this.sleep(ctx);
            }
            case _PROF_CURRENT_MS: {
                return Int.get(System.currentTimeMillis());
            }
            case _PROF_CURRENT_NS: {
                return Int.get(System.nanoTime());
            }
            case _PROF_DUMP: {
                return this.dump(ctx);
            }
            case _PROF_HUMAN: {
                return this.human(ctx);
            }
            case _PROF_VOID: {
                return this.voidd(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Iter mem(final QueryContext ctx) throws QueryException {
        byte[] msg;
        Performance.gc(3);
        final long min = Performance.memory();
        byte[] byArray = msg = this.expr.length > 2 ? this.checkStr(this.expr[2], ctx) : null;
        if (this.expr.length > 1 && this.checkBln(this.expr[1], ctx)) {
            Value v = ctx.value(this.expr[0]).cache().value();
            FNProf.dump(min, msg, ctx);
            return v.iter();
        }
        return new Iter(){
            final Iter ir;
            {
                this.ir = FNProf.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                Item it = this.ir.next();
                if (it == null) {
                    FNProf.dump(min, msg, ctx);
                }
                return it;
            }
        };
    }

    private Item dump(QueryContext ctx) throws QueryException {
        Item it;
        Iter ir = this.expr[0].iter(ctx);
        byte[] label = this.expr.length > 1 ? this.checkStr(this.expr[1], ctx) : null;
        boolean empty = true;
        while ((it = ir.next()) != null) {
            FNInfo.dump(it, label, this.info, ctx);
            empty = false;
        }
        if (empty) {
            FNInfo.dump(null, label, this.info, ctx);
        }
        return null;
    }

    private Item voidd(QueryContext ctx) throws QueryException {
        Item it;
        Iter ir = this.expr[0].iter(ctx);
        while ((it = ir.next()) != null) {
            it.materialize(this.info);
        }
        return null;
    }

    private static void dump(long min, byte[] msg, QueryContext ctx) {
        Performance.gc(2);
        long max = Performance.memory();
        long mb = Math.max(0L, max - min);
        FNInfo.dump(Token.token(Performance.format(mb)), msg, ctx);
    }

    private Item human(QueryContext ctx) throws QueryException {
        return Str.get(Performance.format(this.checkItr(this.expr[0], ctx), true));
    }

    private Iter time(final QueryContext ctx) throws QueryException {
        byte[] msg;
        final Performance p = new Performance();
        byte[] byArray = msg = this.expr.length > 2 ? this.checkStr(this.expr[2], ctx) : null;
        if (this.expr.length > 1 && this.checkBln(this.expr[1], ctx)) {
            Value v = ctx.value(this.expr[0]).cache().value();
            FNInfo.dump(Token.token(p.getTime()), msg, ctx);
            return v.iter();
        }
        return new Iter(){
            final Iter ir;
            {
                this.ir = FNProf.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                Item it = this.ir.next();
                if (it == null) {
                    FNInfo.dump(Token.token(p.getTime()), msg, ctx);
                }
                return it;
            }
        };
    }

    private Item sleep(QueryContext ctx) throws QueryException {
        Performance.sleep(this.checkItr(this.expr[0], ctx));
        return null;
    }
}

