/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.gflwor;

import java.util.ArrayList;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.Function;
import org.basex.query.gflwor.For;
import org.basex.query.gflwor.GFLWOR;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class Let
extends GFLWOR.Clause {
    public final Var var;
    public Expr expr;
    private final boolean score;

    public Let(Var v, Expr e, boolean scr, InputInfo ii) {
        super(ii, v);
        this.var = v;
        this.expr = e;
        this.score = scr;
    }

    static Let fromFor(For fr) {
        Let lt = new Let(fr.var, fr.expr, false, fr.info);
        lt.type = fr.expr.type();
        return lt;
    }

    static Let fromForScore(For fr) {
        VarRef varRef = new VarRef(fr.info, fr.var);
        return new Let(fr.score, varRef, true, fr.info);
    }

    @Override
    LetEval eval(GFLWOR.Eval sub) {
        if (!(sub instanceof LetEval)) {
            return new LetEval(this, sub);
        }
        LetEval eval = (LetEval)sub;
        eval.lets.add(this);
        return eval;
    }

    private static Dbl score(Iter iter) throws QueryException {
        Item it;
        double sum = 0.0;
        int sz = 0;
        while ((it = iter.next()) != null) {
            sum += it.score();
            ++sz;
        }
        return Dbl.get(sum / (double)sz);
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(new Object[0]);
        if (this.score) {
            e.add(this.planAttr(Token.token("score"), Token.TRUE));
        }
        this.var.plan(e);
        this.expr.plan(e);
        plan.add(e);
    }

    @Override
    public String toString() {
        return "let " + (this.score ? "score " : "") + this.var + ' ' + ":=" + ' ' + this.expr;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.expr.has(flag);
    }

    @Override
    public Let compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.var.refineType(this.score ? SeqType.DBL : this.expr.type(), ctx, this.info);
        this.expr = this.expr.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Let optimize(QueryContext ctx, VarScope scp) throws QueryException {
        TypeCheck tc;
        if (!this.score && this.expr instanceof TypeCheck && ((tc = (TypeCheck)this.expr).isRedundant(this.var) || this.var.adoptCheck(tc.type, tc.promote))) {
            ctx.compInfo("removing redundant % cast.", tc.type);
            this.expr = tc.expr;
        }
        this.type = this.score ? SeqType.DBL : this.expr.type();
        this.var.refineType(this.type, ctx, this.info);
        if (this.var.checksType() && this.expr.isValue()) {
            this.expr = this.var.checkType((Value)this.expr, ctx, this.info, true);
            this.var.refineType(this.expr.type(), ctx, this.info);
        }
        this.size = this.score ? 1L : this.expr.size();
        return this;
    }

    @Override
    public boolean removable(Var v) {
        return this.expr.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        return this.expr.count(v);
    }

    @Override
    public GFLWOR.Clause inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        Expr sub = this.expr.inline(ctx, scp, v, e);
        if (sub == null) {
            return null;
        }
        this.expr = sub;
        return this.optimize(ctx, scp);
    }

    @Override
    public Let copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Var v = scp.newCopyOf(ctx, this.var);
        vs.put(this.var.id, v);
        return new Let(v, this.expr.copy(ctx, scp, vs), this.score, this.info);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && visitor.declared(this.var);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    long calcSize(long cnt) {
        return cnt;
    }

    public Expr inlineExpr(QueryContext ctx, VarScope scp) throws QueryException {
        return this.score ? Function._FT_SCORE.get(null, this.expr).optimize(ctx, scp) : this.var.checked(this.expr, ctx, scp, this.info);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    private static class LetEval
    implements GFLWOR.Eval {
        private final ArrayList<Let> lets = new ArrayList();
        private final GFLWOR.Eval sub;

        LetEval(Let let, GFLWOR.Eval subEval) {
            this.lets.add(let);
            this.sub = subEval;
        }

        @Override
        public boolean next(QueryContext ctx) throws QueryException {
            if (!this.sub.next(ctx)) {
                return false;
            }
            for (Let let : this.lets) {
                ctx.set(let.var, let.score ? Let.score(let.expr.iter(ctx)) : ctx.value(let.expr), let.info);
            }
            return true;
        }
    }
}

