/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.gflwor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Single;
import org.basex.query.gflwor.GFLWOR;
import org.basex.query.gflwor.Where;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class OrderBy
extends GFLWOR.Clause {
    private VarRef[] refs;
    private final Key[] keys;

    public OrderBy(VarRef[] vs, Key[] ks, InputInfo ii) {
        super(ii, new Var[0]);
        this.refs = vs;
        this.keys = ks;
    }

    @Override
    GFLWOR.Eval eval(final GFLWOR.Eval sub) {
        return new GFLWOR.Eval(){
            private Value[][] tpls;
            private Integer[] perm;
            int pos;

            @Override
            public boolean next(QueryContext ctx) throws QueryException {
                if (this.tpls == null) {
                    this.sort(ctx);
                }
                if (this.pos == this.tpls.length) {
                    return false;
                }
                int p = this.perm[this.pos++];
                Value[] tuple = this.tpls[p];
                this.tpls[p] = null;
                for (int i = 0; i < OrderBy.this.refs.length; ++i) {
                    ctx.set(((OrderBy)OrderBy.this).refs[i].var, tuple[i], OrderBy.this.info);
                }
                return true;
            }

            private void sort(QueryContext ctx) throws QueryException {
                int i;
                ArrayList<Value[]> tuples = new ArrayList<Value[]>();
                while (sub.next(ctx)) {
                    Item[] key = new Item[OrderBy.this.keys.length];
                    for (int i2 = 0; i2 < OrderBy.this.keys.length; ++i2) {
                        key[i2] = ((OrderBy)OrderBy.this).keys[i2].expr.item(ctx, ((OrderBy)OrderBy.this).keys[i2].info);
                    }
                    tuples.add(key);
                    Value[] vals = new Value[OrderBy.this.refs.length];
                    for (i = 0; i < OrderBy.this.refs.length; ++i) {
                        vals[i] = OrderBy.this.refs[i].value(ctx);
                    }
                    tuples.add(vals);
                }
                int len = tuples.size() >>> 1;
                final Item[][] ks = new Item[len][];
                this.perm = new Integer[len];
                this.tpls = new Value[len][];
                for (i = 0; i < len; ++i) {
                    this.perm[i] = i;
                    this.tpls[i] = (Value[])tuples.get(i << 1 | 1);
                    ks[i] = (Item[])tuples.get(i << 1);
                }
                tuples = null;
                try {
                    Arrays.sort(this.perm, new Comparator<Integer>(){

                        @Override
                        public int compare(Integer x, Integer y) {
                            try {
                                Item[] a = ks[x];
                                Item[] b = ks[y];
                                for (int k = 0; k < OrderBy.this.keys.length; ++k) {
                                    int c;
                                    Key or = OrderBy.this.keys[k];
                                    Item m = a[k];
                                    Item n = b[k];
                                    if (m == Dbl.NAN || m == Flt.NAN) {
                                        m = null;
                                    }
                                    if (n == Dbl.NAN || n == Flt.NAN) {
                                        n = null;
                                    }
                                    if (m != null && n != null && !m.comparable(n)) {
                                        throw Err.castError(or.info, m.type, n);
                                    }
                                    int n2 = m == null ? (n == null ? 0 : (or.least ? -1 : 1)) : (n == null ? (or.least ? 1 : -1) : (c = m.diff(n, or.coll, or.info)));
                                    if (c == 0) continue;
                                    return or.desc ? -c : c;
                                }
                                return 0;
                            }
                            catch (QueryException ex) {
                                throw new QueryRTException(ex);
                            }
                        }
                    });
                }
                catch (QueryRTException ex) {
                    throw ex.getCause();
                }
            }
        };
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(new Object[0]);
        for (Key k : this.keys) {
            k.plan(e);
        }
        plan.add(e);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("order").append(' ').append("by");
        for (int i = 0; i < this.keys.length; ++i) {
            sb.append(i == 0 ? " " : ", ").append(this.keys[i]);
        }
        return sb.toString();
    }

    @Override
    public boolean has(Expr.Flag flag) {
        for (Key k : this.keys) {
            if (!k.has(flag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OrderBy compile(QueryContext cx, VarScope sc) throws QueryException {
        for (Key k : this.keys) {
            k.compile(cx, sc);
        }
        return this;
    }

    @Override
    public OrderBy optimize(QueryContext ctx, VarScope scp) {
        return this;
    }

    @Override
    public boolean removable(Var v) {
        for (Key k : this.keys) {
            if (k.removable(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public VarUsage count(Var v) {
        return VarUsage.sum(v, this.keys);
    }

    @Override
    public GFLWOR.Clause inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        int i = this.refs.length;
        while (--i >= 0) {
            if (!v.is(this.refs[i].var)) continue;
            this.refs = Array.delete(this.refs, i);
        }
        return OrderBy.inlineAll(ctx, scp, this.keys, v, e) ? this.optimize(ctx, scp) : null;
    }

    @Override
    public OrderBy copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new OrderBy((VarRef[])Arr.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.refs), (Key[])Arr.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.keys), this.info);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return OrderBy.visitAll(visitor, this.keys);
    }

    @Override
    boolean clean(QueryContext ctx, IntObjMap<Var> decl, BitArray used) {
        int len = this.refs.length;
        int i = this.refs.length;
        while (--i >= 0) {
            if (used.get(this.refs[i].var.id)) continue;
            this.refs = Array.delete(this.refs, i);
        }
        if (this.refs.length == used.cardinality()) {
            return this.refs.length != len;
        }
        int id = used.nextSet(0);
        while (id >= 0) {
            block5: {
                for (VarRef ref : this.refs) {
                    if (ref.var.id != id) {
                        continue;
                    }
                    break block5;
                }
                this.refs = Array.add(this.refs, new VarRef(this.info, decl.get(id)));
            }
            id = used.nextSet(id + 1);
        }
        return true;
    }

    @Override
    boolean skippable(GFLWOR.Clause cl) {
        return cl instanceof Where;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.keys);
    }

    @Override
    long calcSize(long cnt) {
        return cnt;
    }

    @Override
    public int exprSize() {
        int sz = 0;
        for (VarRef varRef : this.refs) {
            sz += ((Expr)varRef).exprSize();
        }
        for (ParseExpr parseExpr : this.keys) {
            sz += parseExpr.exprSize();
        }
        return sz;
    }

    public static final class Key
    extends Single {
        final boolean desc;
        final boolean least;
        final Collation coll;

        public Key(InputInfo ii, Expr k, boolean dsc, boolean lst, Collation cl) {
            super(ii, k);
            this.desc = dsc;
            this.least = lst;
            this.coll = cl;
        }

        @Override
        public Key copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
            return new Key(this.info, this.expr.copy(ctx, scp, vs), this.desc, this.least, this.coll);
        }

        @Override
        public void plan(FElem plan) {
            FElem e = this.planElem(QueryText.DIR, Token.token(this.desc ? "descending" : "ascending"), Token.token("empty"), Token.token(this.least ? "least" : "greatest"));
            this.expr.plan(e);
            plan.add(e);
        }

        @Override
        public String toString() {
            TokenBuilder tb = new TokenBuilder(this.expr.toString());
            if (this.desc) {
                tb.add(32).add("descending");
            }
            tb.add(32).add("empty").add(32).add(this.least ? "least" : "greatest");
            if (this.coll != null) {
                tb.add(32).add("collation").add(" \"").add(this.coll.uri()).add(34);
            }
            return tb.toString();
        }

        @Override
        public int exprSize() {
            return this.expr.exprSize();
        }
    }
}

