/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.path.Test;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.Util;

public final class NameTest
extends Test {
    public final byte[] local;
    private final byte[] defElemNS;

    public NameTest(boolean attr) {
        this(null, Test.Kind.WILDCARD, attr, null);
    }

    public NameTest(QNm name, Test.Kind mode, boolean attr, byte[] elemNS) {
        this.type = attr ? NodeType.ATT : NodeType.ELM;
        this.local = name != null ? name.local() : null;
        this.defElemNS = elemNS != null ? elemNS : Token.EMPTY;
        this.name = name;
        this.kind = mode;
    }

    @Override
    public boolean compile(QueryContext ctx) {
        Data data = ctx.data();
        if (data == null) {
            return true;
        }
        byte[] dataNS = data.nspaces.globalNS();
        if (dataNS == null) {
            return true;
        }
        boolean results = true;
        if (this.kind == Test.Kind.URI_NAME && !this.name.hasURI()) {
            if (this.type == NodeType.ATT || Token.eq(dataNS, this.defElemNS)) {
                this.kind = Test.Kind.NAME;
            } else {
                results = false;
            }
        }
        if (results) {
            boolean bl = this.kind != Test.Kind.NAME || (this.type == NodeType.ELM ? data.tagindex : data.atnindex).contains(this.local) ? true : (results = false);
        }
        if (!results) {
            ctx.compInfo("removing unknown element/attribute %", this.name);
        }
        return results;
    }

    @Override
    public Test copy() {
        return this;
    }

    @Override
    public boolean eq(ANode node) {
        if (node.type != this.type) {
            return false;
        }
        switch (this.kind) {
            case WILDCARD: {
                return true;
            }
            case NAME: {
                return Token.eq(this.local, Token.local(node.name()));
            }
            case URI: {
                return Token.eq(this.name.uri(), node.qname(this.tmpq).uri());
            }
        }
        return this.type == NodeType.ATT && !this.name.hasURI() ? Token.eq(this.local, node.name()) : this.name.eq(node.qname(this.tmpq));
    }

    public boolean eq(QNm nm) {
        switch (this.kind) {
            case WILDCARD: {
                return true;
            }
            case NAME: {
                return Token.eq(this.local, nm.local());
            }
            case URI: {
                return Token.eq(this.name.uri(), nm.uri());
            }
        }
        return this.name.eq(nm);
    }

    public boolean eq(NameTest test) {
        if (this.kind != test.kind) {
            return false;
        }
        switch (this.kind) {
            case WILDCARD: {
                return true;
            }
            case NAME: {
                return Token.eq(this.local, test.local);
            }
            case URI: {
                return Token.eq(this.name.uri(), test.name.uri());
            }
        }
        return this.name.eq(test.name);
    }

    @Override
    public Test intersect(Test other) {
        throw Util.notExpected(other);
    }

    public String toString() {
        if (this.kind == Test.Kind.WILDCARD) {
            return "*";
        }
        if (this.kind == Test.Kind.NAME) {
            return "*:" + Token.string(this.name.string());
        }
        String uri = this.name.uri().length == 0 || this.name.hasPrefix() ? "" : '{' + Token.string(this.name.uri()) + '}';
        return uri + (this.kind == Test.Kind.URI ? "*" : Token.string(this.name.string()));
    }
}

