/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.query.path.KindTest;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public class NodeTest
extends Test {
    private final Type ext;
    private final boolean strip;

    public NodeTest(QNm nm) {
        this(NodeType.ELM, nm, null, false);
    }

    public NodeTest(NodeType nt, QNm nm) {
        this(nt, nm, null, false);
    }

    public NodeTest(NodeType nt, QNm nm, Type et, boolean st) {
        this.type = nt;
        this.name = nm;
        this.ext = et;
        this.strip = st;
    }

    @Override
    public Test copy() {
        return new NodeTest(this.type, this.name, this.ext, this.strip);
    }

    @Override
    public boolean eq(ANode node) {
        return !(node.type != this.type || this.name != null && !node.qname(this.tmpq).eq(this.name) || this.ext != null && this.ext != AtomType.ATY && (!(node instanceof DBNode) && !this.strip || this.ext != AtomType.UTY) && (this.type != NodeType.ATT || this.ext != AtomType.AST && this.ext != AtomType.AAT && this.ext != AtomType.ATM));
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (this.name == null) {
            tb.add(42);
        } else {
            tb.add(this.name.string());
        }
        if (this.ext != null) {
            tb.add(44).addExt(this.ext, new Object[0]);
        }
        return tb.toString();
    }

    @Override
    public Test intersect(Test other) {
        if (other instanceof NodeTest) {
            Type e;
            boolean both;
            NodeType nt;
            NodeTest o = (NodeTest)other;
            if (this.type != null && o.type != null && this.type != o.type) {
                return null;
            }
            NodeType nodeType = nt = this.type != null ? this.type : o.type;
            if (this.name != null && o.name != null && !this.name.eq(o.name)) {
                return null;
            }
            QNm n = this.name != null ? this.name : o.name;
            boolean bl = both = this.ext != null && o.ext != null;
            Type type = this.ext == null ? o.ext : (e = o.ext == null ? this.ext : this.ext.intersect(o.ext));
            return both && e == null ? null : new NodeTest(nt, n, e, this.strip || o.strip);
        }
        if (other instanceof KindTest) {
            return this.type.instanceOf(other.type) ? this : null;
        }
        if (other instanceof NameTest) {
            throw Util.notExpected(other);
        }
        return null;
    }
}

