/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.regex;

import org.basex.query.regex.RegExp;

public class Literal
extends RegExp {
    private final int codepoint;

    public Literal(int cp) {
        this.codepoint = cp;
    }

    @Override
    StringBuilder toRegEx(StringBuilder sb) {
        return sb.append(Literal.escape(this.codepoint));
    }

    public static String escape(int cp) {
        switch (cp) {
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 10: {
                return "\\n";
            }
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 63: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 124: 
            case 125: {
                return "\\" + (char)cp;
            }
        }
        if (cp < 128 && !Character.isISOControl(cp)) {
            return String.valueOf((char)cp);
        }
        if (cp < 65536) {
            return String.format("\\u%04x", cp);
        }
        return String.valueOf(Character.toChars(cp));
    }
}

