/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import org.basex.core.MainOptions;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.up.ContextModifier;
import org.basex.query.up.DatabaseModifier;
import org.basex.query.up.primitives.Update;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.hash.IntObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.StringList;

public final class Updates {
    public ContextModifier mod;
    public final TokenSet putPaths = new TokenSet();
    private final IntObjMap<MemData> fragmentIDs = new IntObjMap();

    public void add(Update up, QueryContext ctx) throws QueryException {
        if (this.mod == null) {
            this.mod = new DatabaseModifier();
        }
        this.mod.add(up, ctx);
    }

    public DBNode determineDataRef(ANode target, QueryContext ctx) {
        ANode p;
        if (target instanceof DBNode) {
            return (DBNode)target;
        }
        ANode anc = target;
        AxisIter it = target.ancestor();
        while ((p = it.next()) != null) {
            anc = p;
        }
        int ancID = anc.id;
        MemData data = this.fragmentIDs.get(ancID);
        if (data == null) {
            data = (MemData)anc.dbCopy((MainOptions)ctx.context.options).data;
            this.fragmentIDs.put(ancID, data);
        }
        int pre = Updates.preSteps(anc, target.id);
        return new DBNode(data, pre);
    }

    public void apply() throws QueryException {
        if (this.mod != null) {
            this.mod.apply();
        }
    }

    public StringList databases() {
        StringList sl = new StringList(1);
        if (this.mod != null) {
            this.mod.databases(sl);
        }
        return sl;
    }

    public int size() {
        return this.mod == null ? 0 : this.mod.size();
    }

    private static int preSteps(ANode node, int trgID) {
        ANode n;
        if (node.id == trgID) {
            return 0;
        }
        int s = 1;
        AxisMoreIter it = node.attributes();
        while ((n = it.next()) != null) {
            int st = Updates.preSteps(n, trgID);
            if (st == 0) {
                return s;
            }
            s += st;
        }
        it = node.children();
        while ((n = it.next()) != null && trgID - n.id >= 0) {
            s += Updates.preSteps(n, trgID);
        }
        return s;
    }
}

