/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Constr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.up.expr.Update;
import org.basex.query.up.primitives.ReplaceNode;
import org.basex.query.up.primitives.ReplaceValue;
import org.basex.query.util.ANodeList;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FPI;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Replace
extends Update {
    private final boolean value;

    public Replace(StaticContext sctx, InputInfo info, Expr trg, Expr src, boolean value) {
        super(sctx, info, trg, src);
        this.value = value;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Constr c = new Constr(ii, this.sc).add(ctx, this.expr[1]);
        if (c.errAtt) {
            throw Err.UPNOATTRPER.get(this.info, new Object[0]);
        }
        if (c.duplAtt != null) {
            throw Err.UPATTDUPL.get(this.info, new QNm(c.duplAtt));
        }
        Iter t = ctx.iter(this.expr[0]);
        Item i = t.next();
        if (i == null) {
            throw Err.UPSEQEMP.get(this.info, Util.className(this));
        }
        Type tp = i.type;
        if (!(i instanceof ANode) || tp == NodeType.DOC || t.next() != null) {
            throw Err.UPTRGMULT.get(this.info, new Object[0]);
        }
        ANode targ = (ANode)i;
        DBNode dbn = ctx.updates.determineDataRef(targ, ctx);
        ANodeList aList = c.atts;
        ANodeList list = c.children;
        if (this.value) {
            byte[] txt;
            byte[] byArray = list.size() < 1 ? (aList.size() < 1 ? Token.EMPTY : aList.get(0).string()) : (txt = list.get(0).string());
            if (tp == NodeType.COM) {
                FComm.parse(txt, this.info);
            }
            if (tp == NodeType.PI) {
                FPI.parse(txt, this.info);
            }
            ctx.updates.add(new ReplaceValue(dbn.pre, dbn.data, this.info, txt), ctx);
        } else {
            ANode par = targ.parent();
            if (par == null) {
                throw Err.UPNOPAR.get(this.info, i);
            }
            if (tp == NodeType.ATT) {
                if (!list.isEmpty()) {
                    throw Err.UPWRATTR.get(this.info, new Object[0]);
                }
                list = this.checkNS(aList, par);
            } else if (!aList.isEmpty()) {
                throw Err.UPWRELM.get(this.info, new Object[0]);
            }
            ctx.updates.add(new ReplaceNode(dbn.pre, dbn.data, this.info, list), ctx);
        }
        return null;
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new Replace(this.sc, this.info, this.expr[0].copy(ctx, scp, vs), this.expr[1].copy(ctx, scp, vs), this.value);
    }

    @Override
    public String toString() {
        return "replace" + (this.value ? " value of" : "") + ' ' + "node" + ' ' + this.expr[0] + ' ' + "with" + ' ' + this.expr[1];
    }
}

