/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.atomic.DataClip;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBNew;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.DBUpdate;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.options.Options;

public final class DBAdd
extends DBUpdate {
    private final DBOptions options;
    private final QueryContext qc;
    private final DBNew add;
    private int size;

    public DBAdd(Data data, NewInput input, Options opts, QueryContext qc, InputInfo info) throws QueryException {
        super(UpdateType.DBADD, data, info);
        this.qc = qc;
        this.options = new DBOptions(opts.free(), Arrays.asList(DBOptions.PARSING), info);
        ArrayList<NewInput> docs = new ArrayList<NewInput>();
        docs.add(input);
        this.add = new DBNew(qc, docs, info);
    }

    @Override
    public void merge(Update up) {
        DBAdd a = (DBAdd)up;
        for (NewInput input : a.add.inputs) {
            this.add.inputs.add(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(MemData tmp) throws QueryException {
        this.size = this.add.inputs.size();
        MainOptions opts = this.qc.context.options;
        this.options.assign(opts);
        try {
            this.add.addDocs(new MemData(tmp), this.data.meta.name);
        }
        finally {
            this.options.reset(opts);
        }
    }

    @Override
    public void apply() {
        this.data.insert(this.data.meta.size, -1, new DataClip(this.add.md));
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return Util.className(this) + '[' + this.add.inputs + ']';
    }
}

