/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.atomic.DataClip;
import org.basex.query.up.NamePool;
import org.basex.query.up.primitives.NodeUpdate;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.util.ANodeList;
import org.basex.query.util.DataBuilder;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public abstract class NodeCopy
extends NodeUpdate {
    ANodeList insert;
    DataClip insseq;

    NodeCopy(UpdateType t, int p, Data d, InputInfo i, ANodeList n) {
        super(t, p, d, i);
        this.insert = n;
    }

    public final void prepare(MemData tmp) {
        ANodeList list = NodeCopy.mergeNodeCacheText(this.insert);
        this.insert = null;
        int start = tmp.meta.size;
        new DataBuilder(tmp).build(list);
        this.insseq = new DataClip(tmp, start, tmp.meta.size);
        this.insseq.fragments = list.size();
    }

    final void add(NamePool pool) {
        Data d = this.insseq.data;
        int ps = this.insseq.start;
        int pe = this.insseq.end;
        for (int p = ps; p < pe; ++p) {
            int k = d.kind(p);
            if (k != 3 && k != 1) continue;
            if (p > ps && d.parent(p, k) >= ps) break;
            int u = d.uri(p, k);
            QNm qnm = new QNm(d.name(p, k));
            if (u != 0) {
                qnm.uri(d.nspaces.uri(u));
            }
            pool.add(qnm, ANode.type(k));
        }
    }

    private static ANodeList mergeNodeCacheText(ANodeList nl) {
        int ns = nl.size();
        if (ns == 0) {
            return nl;
        }
        ANodeList s = new ANodeList(ns);
        ANode n = nl.get(0);
        int c = 0;
        while (c < ns) {
            if (n.type == NodeType.TXT) {
                TokenBuilder tb = new TokenBuilder();
                while (n.type == NodeType.TXT) {
                    tb.add(n.string());
                    if (++c == ns) break;
                    n = nl.get(c);
                }
                s.add(new FTxt(tb.finish()));
                continue;
            }
            s.add(n);
            if (++c >= ns) continue;
            n = nl.get(c);
        }
        return s;
    }

    @Override
    public final int size() {
        return this.insseq.fragments;
    }

    public final String toString() {
        return Util.className(this) + '[' + this.node() + ", " + this.size() + " ops]";
    }
}

