/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.atomic.AtomicUpdateCache;
import org.basex.query.QueryException;
import org.basex.query.up.NamePool;
import org.basex.query.up.primitives.NodeUpdate;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.util.Err;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class RenameNode
extends NodeUpdate {
    private final QNm name;

    public RenameNode(int p, Data d, InputInfo i, QNm nm) {
        super(UpdateType.RENAMENODE, p, d, i);
        this.name = nm;
    }

    @Override
    public void merge(Update up) throws QueryException {
        throw Err.UPMULTREN.get(this.info, this.node());
    }

    @Override
    public void update(NamePool pool) {
        DBNode node = this.node();
        pool.add(this.name, node.nodeType());
        pool.remove(node);
    }

    public String toString() {
        return Util.className(this) + '[' + this.node() + ", " + this.name + ']';
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void addAtomics(AtomicUpdateCache l) {
        l.addRename(this.pre, this.name.string(), this.name.uri());
    }

    @Override
    public NodeUpdate[] substitute(MemData tmp) {
        return new NodeUpdate[]{this};
    }
}

