/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.EnumSet;
import java.util.Stack;
import org.basex.query.QueryException;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Compare {
    private final InputInfo info;
    private final EnumSet<Mode> flags = EnumSet.noneOf(Mode.class);
    private Collation coll;

    public Compare(InputInfo ii) {
        this.info = ii;
    }

    public Compare flag(Mode f) {
        this.flags.add(f);
        return this;
    }

    public Compare collation(Collation c) {
        this.coll = c;
        return this;
    }

    public static boolean deep(Value val1, Value val2, InputInfo info) throws QueryException {
        return Compare.deep(val1.iter(), val2.iter(), info);
    }

    public static boolean deep(Iter iter1, Iter iter2, InputInfo info) throws QueryException {
        return new Compare(info).deep(iter1, iter2);
    }

    public boolean deep(Iter iter1, Iter iter2) throws QueryException {
        while (true) {
            Item it1 = iter1.next();
            Item it2 = iter2.next();
            if (it1 == null || it2 == null) {
                return it1 == null && it2 == null;
            }
            if (it1 instanceof FItem || it2 instanceof FItem) {
                if (it1 instanceof Map && it2 instanceof Map) {
                    if (((Map)it1).deep(this.info, (Map)it2)) continue;
                    return false;
                }
                throw Err.FICMP.get(this.info, it1 instanceof FItem ? it1.type : it2.type);
            }
            if (it1 == it2) continue;
            if (!(it1 instanceof ANode) && !(it2 instanceof ANode)) {
                if (it1.equiv(it2, this.coll, this.info)) continue;
                return false;
            }
            Type t1 = it1.type;
            Type t2 = it2.type;
            if (t1 != t2) {
                return false;
            }
            ANode s1 = (ANode)it1;
            ANode s2 = (ANode)it2;
            if (s1.is(s2)) continue;
            AxisIter ch1 = s1.children();
            AxisIter ch2 = s2.children();
            Stack<AxisIter> stack = new Stack<AxisIter>();
            stack.push(ch1);
            stack.push(ch2);
            boolean skip = false;
            do {
                t1 = s1 != null ? s1.type : null;
                Type type = t2 = s2 != null ? s2.type : null;
                if (skip) {
                    if (t1 == NodeType.COM || t1 == NodeType.PI) {
                        s1 = ch1.next();
                        continue;
                    }
                    if (t2 == NodeType.COM || t2 == NodeType.PI) {
                        s2 = ch2.next();
                        continue;
                    }
                }
                if (s1 == null || s2 == null) {
                    if (s1 != s2) {
                        return false;
                    }
                    ch2 = (AxisIter)stack.pop();
                    ch1 = (AxisIter)stack.pop();
                } else {
                    if (t1 != t2) {
                        return false;
                    }
                    QNm n1 = s1.qname();
                    QNm n2 = s2.qname();
                    if (n1 != null && (!n1.eq(n2) || this.flags.contains((Object)Mode.NAMESPACES) && !Token.eq(n1.prefix(), n2.prefix()))) {
                        return false;
                    }
                    if (t1 == NodeType.TXT || t1 == NodeType.ATT || t1 == NodeType.COM || t1 == NodeType.PI || t1 == NodeType.NSP) {
                        if (!Token.eq(s1.string(), s2.string())) {
                            return false;
                        }
                    } else if (t1 == NodeType.ELM) {
                        ANode a1;
                        if (s1.attributes().value().size() != s2.attributes().value().size()) {
                            return false;
                        }
                        AxisMoreIter ai1 = s1.attributes();
                        block2: while ((a1 = ai1.next()) != null) {
                            ANode a2;
                            n1 = a1.qname();
                            AxisMoreIter ai2 = s2.attributes();
                            while ((a2 = ai2.next()) != null) {
                                n2 = a2.qname();
                                if (!n1.eq(n2)) continue;
                                if ((!this.flags.contains((Object)Mode.NAMESPACES) || Token.eq(n1.prefix(), n2.prefix())) && Token.eq(a1.string(), a2.string())) continue block2;
                                return false;
                            }
                            return false;
                        }
                        if (this.flags.contains((Object)Mode.NAMESPACES)) {
                            Atts ns1 = s1.namespaces();
                            Atts ns2 = s2.namespaces();
                            if (ns1.size() != ns2.size()) {
                                return false;
                            }
                            block4: for (int i1 = 0; i1 < ns1.size(); ++i1) {
                                for (int i2 = 0; i2 < ns2.size(); ++i2) {
                                    if (!Token.eq(ns1.name(i1), ns2.name(i2))) continue;
                                    if (Token.eq(ns1.value(i1), ns2.value(i2))) continue block4;
                                    return false;
                                }
                                return false;
                            }
                        }
                        stack.push(ch1);
                        stack.push(ch2);
                        ch1 = s1.children();
                        ch2 = s2.children();
                    }
                }
                s1 = ch1.next();
                s2 = ch2.next();
                boolean bl = skip = !this.flags.contains((Object)Mode.ALLNODES);
            } while (!stack.isEmpty());
        }
    }

    public static enum Mode {
        ALLNODES,
        NAMESPACES;

    }
}

