/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgParser;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;

public final class Repo {
    final Context context;
    private final TokenObjMap<TokenSet> nsDict = new TokenObjMap();
    private final TokenMap pkgDict = new TokenMap();
    private IOFile path;

    public Repo(Context ctx) {
        this.context = ctx;
    }

    public IOFile path() {
        return this.init().path;
    }

    public TokenObjMap<TokenSet> nsDict() {
        return this.init().nsDict;
    }

    public TokenMap pkgDict() {
        return this.init().pkgDict;
    }

    public IOFile path(String pkg) {
        return new IOFile(this.init().path, pkg);
    }

    synchronized void add(Package pkg, String dir) {
        this.init();
        byte[] name = pkg.uniqueName();
        for (Package.Component comp : pkg.comps) {
            TokenSet dict = this.nsDict.get(comp.uri);
            if (dict != null) {
                dict.add(name);
                continue;
            }
            this.nsDict.put(comp.uri, new TokenSet(new byte[][]{name}));
        }
        this.pkgDict.put(name, Token.token(dir));
    }

    synchronized void delete(Package pkg) {
        this.init();
        byte[] name = pkg.uniqueName();
        for (Package.Component comp : pkg.comps) {
            byte[] uri = comp.uri;
            TokenSet pkgs = this.nsDict.get(uri);
            if (pkgs.size() > 1) {
                pkgs.delete(name);
                continue;
            }
            this.nsDict.delete(uri);
        }
        this.pkgDict.delete(name);
    }

    private Repo init() {
        if (this.path == null) {
            this.path = new IOFile(this.context.globalopts.get(GlobalOptions.REPOPATH));
            for (IOFile dir : this.path.children()) {
                if (!dir.isDir()) continue;
                this.readPkg(dir);
            }
        }
        return this;
    }

    private void readPkg(IOFile dir) {
        IOFile desc = new IOFile(dir, "expath-pkg.xml");
        if (!desc.exists()) {
            return;
        }
        try {
            Package pkg = new PkgParser(this.context.repo, null).parse(desc);
            byte[] name = pkg.uniqueName();
            for (Package.Component comp : pkg.comps) {
                if (comp.uri == null) continue;
                TokenSet dict = this.nsDict.get(comp.uri);
                if (dict != null) {
                    dict.add(name);
                    continue;
                }
                this.nsDict.put(comp.uri, new TokenSet(new byte[][]{name}));
            }
            this.pkgDict.put(name, Token.token(dir.name()));
        }
        catch (QueryException ex) {
            Util.errln(ex, new Object[0]);
        }
    }
}

