/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.basex.query.QueryException;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public abstract class ADate
extends ADateDur {
    static final long MAX_YEAR = 25252734927766554L;
    static final long MIN_YEAR = -25252734927766554L;
    private static final long ADD_NEG = 25252734927766800L;
    static final String DD = "(\\d{2})";
    static final String YEAR = "(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))";
    static final String ZONE = "((\\+|-)(\\d{2}):(\\d{2})|Z)?";
    static final byte[] DAYS = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final Pattern DATE = Pattern.compile("(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))-(\\d{2})-(\\d{2})((\\+|-)(\\d{2}):(\\d{2})|Z)?");
    private static final Pattern TIME = Pattern.compile("(\\d{2}):(\\d{2}):(\\d{2}(\\.\\d+)?)((\\+|-)(\\d{2}):(\\d{2})|Z)?");
    long yea = Long.MAX_VALUE;
    byte mon = (byte)-1;
    byte day = (byte)-1;
    byte hou = (byte)-1;
    byte min = (byte)-1;
    short zon = Short.MAX_VALUE;
    public static DatatypeFactory df;

    ADate(Type typ, ADate d) {
        super(typ);
        this.yea = d.yea;
        this.mon = d.mon;
        this.day = d.day;
        this.hou = d.hou;
        this.min = d.min;
        this.sec = d.sec;
        this.zon = d.zon;
    }

    ADate(Type typ) {
        super(typ);
    }

    final void date(byte[] d, String e, InputInfo ii) throws QueryException {
        Matcher mt = DATE.matcher(Token.string(d).trim());
        if (!mt.matches()) {
            throw this.dateError(d, e, ii);
        }
        this.yea = this.toLong(mt.group(1), false, ii);
        if (this.yea < 0L) {
            ++this.yea;
        }
        this.mon = (byte)(Token.toInt(mt.group(3)) - 1);
        this.day = (byte)(Token.toInt(mt.group(4)) - 1);
        if (this.mon < 0 || this.mon >= 12 || this.day < 0 || this.day >= ADate.dpm(this.yea, this.mon)) {
            throw this.dateError(d, e, ii);
        }
        if (this.yea <= -25252734927766554L || this.yea > 25252734927766554L) {
            throw Err.DATERANGE.get(ii, this.type, Err.chop(d));
        }
        this.zone(mt, 5, d, ii);
    }

    final void time(byte[] d, String e, InputInfo ii) throws QueryException {
        Matcher mt = TIME.matcher(Token.string(d).trim());
        if (!mt.matches()) {
            throw this.dateError(d, e, ii);
        }
        this.hou = (byte)Token.toInt(mt.group(1));
        this.min = (byte)Token.toInt(mt.group(2));
        this.sec = this.toDecimal(mt.group(3), false, ii);
        if (this.min >= 60 || this.sec.compareTo(BD60) >= 0 || this.hou > 24 || this.hou == 24 && (this.min > 0 || this.sec.compareTo(BigDecimal.ZERO) > 0)) {
            throw this.dateError(d, e, ii);
        }
        this.zone(mt, 5, d, ii);
        if (this.hou == 24) {
            this.hou = 0;
            this.add(DAYSECONDS);
        }
    }

    final void zone(Matcher mt, int p, byte[] val, InputInfo ii) throws QueryException {
        String tz = mt.group(p);
        if (tz == null) {
            return;
        }
        if ("Z".equals(tz)) {
            this.zon = 0;
        } else {
            int th = Token.toInt(mt.group(p + 2));
            int tm = Token.toInt(mt.group(p + 3));
            if (th > 14 || tm > 59 || th == 14 && tm != 0) {
                throw Err.INVALIDZONE.get(ii, new Object[]{val});
            }
            int mn = th * 60 + tm;
            this.zon = (short)("-".equals(mt.group(p + 1)) ? -mn : mn);
        }
    }

    final void calc(DTDur dur, boolean p) {
        this.add(p ? dur.sec : dur.sec.negate());
    }

    final void calc(YMDur dur, boolean p, InputInfo ii) throws QueryException {
        long m = p ? dur.mon : -dur.mon;
        long mn = (long)this.mon + m;
        this.mon = (byte)ADate.mod(mn, 12);
        this.yea += ADate.div(mn, 12);
        this.day = (byte)Math.min(ADate.dpm(this.yea, this.mon) - 1, this.day);
        if (this.yea <= -25252734927766554L || this.yea > 25252734927766554L) {
            throw Err.YEARRANGE.get(ii, this.yea);
        }
    }

    private void add(BigDecimal add) {
        BigDecimal sc = this.sec().add(add);
        this.sec = sc.signum() >= 0 ? sc.remainder(BD60) : sc.negate().add(sc.remainder(BD60)).add(BD60).add(sc).remainder(BD60);
        long mn = Math.max(this.min(), 0L) + ADate.div(sc.longValue(), 60);
        this.min = (byte)ADate.mod(mn, 60);
        long ho = (long)Math.max(this.hou, 0) + ADate.div(mn, 60);
        this.hou = (byte)ADate.mod(ho, 24);
        long da = ADate.div(ho, 24);
        long[] ymd = ADate.ymd(this.days().add(BigDecimal.valueOf(da)));
        this.yea = ymd[0];
        this.mon = (byte)ymd[1];
        this.day = (byte)ymd[2];
    }

    private static long mod(long i, int m) {
        return i > 0L ? i % (long)m : (Long.MAX_VALUE / (long)m * (long)m + i) % (long)m;
    }

    private static long div(long i, int d) {
        return i < 0L ? (i + 1L) / (long)d - 1L : i / (long)d;
    }

    public abstract void timeZone(DTDur var1, boolean var2, InputInfo var3) throws QueryException;

    void tz(DTDur tz, boolean spec, InputInfo ii) throws QueryException {
        int t;
        if (spec && tz == null) {
            t = Short.MAX_VALUE;
        } else {
            if (tz == null) {
                Calendar c = Calendar.getInstance();
                t = (short)((c.get(15) + c.get(16)) / 60000);
            } else {
                t = (short)(tz.min() + tz.hou() * 60L);
                if (tz.sec().signum() != 0) {
                    throw Err.ZONESEC.get(ii, tz);
                }
                if (Math.abs(t) > 840 || tz.day() != 0L) {
                    throw Err.INVALZONE.get(ii, tz);
                }
            }
            if (this.zon != Short.MAX_VALUE) {
                this.add(BigDecimal.valueOf(60 * (t - this.zon)));
            }
        }
        this.zon = (short)t;
    }

    @Override
    public final long yea() {
        return this.yea > 0L ? this.yea : this.yea - 1L;
    }

    @Override
    public final long mon() {
        return this.mon + 1;
    }

    @Override
    public final long day() {
        return this.day + 1;
    }

    @Override
    public final long hou() {
        return this.hou;
    }

    @Override
    public final long min() {
        return this.min;
    }

    @Override
    public final BigDecimal sec() {
        return this.sec == null ? BigDecimal.ZERO : this.sec;
    }

    public final int zon() {
        return this.zon;
    }

    @Override
    public byte[] string(InputInfo ii) {
        boolean ymd;
        TokenBuilder tb = new TokenBuilder();
        boolean bl = ymd = this.yea != Long.MAX_VALUE;
        if (ymd) {
            if (this.yea <= 0L) {
                tb.add(45);
            }
            ADate.prefix(tb, Math.abs(this.yea()), 4);
            tb.add(45);
            ADate.prefix(tb, this.mon(), 2);
            tb.add(45);
            ADate.prefix(tb, this.day(), 2);
        }
        if (this.hou >= 0) {
            if (ymd) {
                tb.add(84);
            }
            ADate.prefix(tb, this.hou(), 2);
            tb.add(58);
            ADate.prefix(tb, this.min(), 2);
            tb.add(58);
            if (this.sec.intValue() < 10) {
                tb.add(48);
            }
            tb.addExt(Token.chopNumber(Token.token(this.sec().abs().toPlainString())), new Object[0]);
        }
        this.zone(tb);
        return tb.finish();
    }

    void zone(TokenBuilder tb) {
        if (this.zon == Short.MAX_VALUE) {
            return;
        }
        if (this.zon == 0) {
            tb.add(90);
        } else {
            tb.add(this.zon > 0 ? 43 : 45);
            ADate.prefix(tb, Math.abs(this.zon) / 60, 2);
            tb.add(58);
            ADate.prefix(tb, Math.abs(this.zon) % 60, 2);
        }
    }

    static void prefix(TokenBuilder tb, long n, int z) {
        byte[] t = Token.token(n);
        for (int i = t.length; i < z; ++i) {
            tb.add(48);
        }
        tb.add(t);
    }

    @Override
    public final boolean eq(Item it, Collation coll, InputInfo ii) throws QueryException {
        ADate d = (ADate)(it instanceof ADate ? it : this.type.cast(it, null, null, ii));
        BigDecimal d1 = this.seconds().add(this.days().multiply(DAYSECONDS));
        BigDecimal d2 = d.seconds().add(d.days().multiply(DAYSECONDS));
        return d1.compareTo(d2) == 0;
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return this.seconds().add(this.days().multiply(DAYSECONDS)).intValue();
    }

    @Override
    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        ADate d = (ADate)(it instanceof ADate ? it : this.type.cast(it, null, null, ii));
        BigDecimal d1 = this.seconds().add(this.days().multiply(DAYSECONDS));
        BigDecimal d2 = d.seconds().add(d.days().multiply(DAYSECONDS));
        return d1.compareTo(d2);
    }

    @Override
    public final XMLGregorianCalendar toJava() {
        return df.newXMLGregorianCalendar(this.yea == Long.MAX_VALUE ? null : BigInteger.valueOf(this.yea > 0L ? this.yea : this.yea - 1L), this.mon >= 0 ? this.mon + 1 : Integer.MIN_VALUE, this.day >= 0 ? this.day + 1 : Integer.MIN_VALUE, this.hou >= 0 ? (int)this.hou : Integer.MIN_VALUE, this.min >= 0 ? (int)this.min : Integer.MIN_VALUE, this.sec != null ? this.sec.intValue() : Integer.MIN_VALUE, this.sec != null ? this.sec.remainder(BigDecimal.ONE) : null, this.zon == Short.MAX_VALUE ? Integer.MIN_VALUE : (int)this.zon);
    }

    final BigDecimal seconds() {
        int z = this.zon;
        if (z == Short.MAX_VALUE) {
            long n = System.currentTimeMillis();
            z = Calendar.getInstance().getTimeZone().getOffset(n) / 60000;
        }
        return (this.sec == null ? BigDecimal.ZERO : this.sec).add(BigDecimal.valueOf(Math.max(0, this.hou) * 3600 + Math.max(0, this.min) * 60 - z * 60));
    }

    final BigDecimal days() {
        long y = this.yea == Long.MAX_VALUE ? 1L : this.yea;
        return ADate.days(y + 25252734927766800L, Math.max(this.mon, 0), Math.max(this.day, 0));
    }

    private static BigDecimal days(long yea, int mon, int day) {
        long y = yea - (long)(mon < 2 ? 1 : 0);
        int m = mon + (mon < 2 ? 13 : 1);
        int d = day + 1;
        return BD365.multiply(BigDecimal.valueOf(y)).add(BigDecimal.valueOf(y / 4L - y / 100L + y / 400L - 92L + (long)d + (long)((153 * m - 2) / 5)));
    }

    private static long[] ymd(BigDecimal days) {
        BigDecimal d = days;
        BigDecimal t = d.add(BD36525).multiply(BD4).divideToIntegralValue(BD146097).subtract(BigDecimal.ONE);
        BigDecimal y = BD100.multiply(t);
        d = d.subtract(BD36524.multiply(t).add(t.divideToIntegralValue(BD4)));
        t = d.add(BD366).multiply(BD4).divideToIntegralValue(BD1461).subtract(BigDecimal.ONE);
        y = y.add(t);
        d = d.subtract(BD365.multiply(t).add(t.divideToIntegralValue(BD4)));
        BigDecimal m = BD5.multiply(d).add(BD2).divideToIntegralValue(BD153);
        d = d.subtract(BD153.multiply(m).add(BD2).divideToIntegralValue(BD5));
        long mm = m.longValue();
        if (mm > 9L) {
            mm -= 12L;
            y = y.add(BigDecimal.ONE);
        }
        return new long[]{y.subtract(BigDecimal.valueOf(25252734927766800L)).longValue(), mm + 2L, d.longValue()};
    }

    public static int dpm(long yea, int mon) {
        int l = DAYS[mon];
        return mon == 1 && yea % 4L == 0L && (yea % 100L != 0L || yea % 400L == 0L) ? l + 1 : l;
    }

    @Override
    public final String toString() {
        return Util.info("\"%\"", new Object[]{this.string(null)});
    }

    static {
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (Exception ex) {
            throw Util.notExpected(ex);
        }
    }
}

