/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.data.DataText;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

public final class Atm
extends Item {
    private final byte[] val;

    public Atm(byte[] v) {
        super(AtomType.ATM);
        this.val = v;
    }

    public Atm(String v) {
        this(Token.token(v));
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.val;
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.val.length != 0;
    }

    @Override
    public boolean eq(Item it, Collation coll, InputInfo ii) throws QueryException {
        return it.type.isUntyped() ? (coll == null ? Token.eq(this.val, it.string(ii)) : coll.compare(this.val, it.string(ii)) == 0) : it.eq(this, coll, ii);
    }

    @Override
    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        return it.type.isUntyped() ? (coll == null ? Token.diff(this.val, it.string(ii)) : coll.compare(this.val, it.string(ii))) : -it.diff(this, coll, ii);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof Atm && Token.eq(this.val, ((Atm)cmp).val);
    }

    @Override
    public String toJava() {
        return Token.string(this.val);
    }

    @Override
    public String toString() {
        ByteList tb = new ByteList();
        tb.add(34);
        for (byte v : this.val) {
            if (v == 38) {
                tb.add(DataText.E_AMP);
            } else {
                tb.add(v);
            }
            if (v != 34) continue;
            tb.add(34);
        }
        return tb.add(34).toString();
    }
}

