/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.Function;
import org.basex.query.util.Err;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class StrStream
extends AStr {
    private final IO input;
    private final String encoding;
    private final Err error;
    private final boolean validate;

    public StrStream(IO io, String enc, Err err, QueryContext ctx) {
        this.input = io;
        this.encoding = enc;
        this.error = err;
        this.validate = ctx.context.options.get(MainOptions.CHECKSTRINGS);
    }

    @Override
    public byte[] string(InputInfo ii) throws QueryException {
        try {
            return this.input(ii).content();
        }
        catch (IOException ex) {
            throw this.error.get(ii, ex);
        }
    }

    @Override
    public String toJava() throws QueryException {
        return Token.string(this.string(null));
    }

    @Override
    public TextInput input(InputInfo ii) throws QueryException {
        TextInput nli = null;
        try {
            nli = new TextInput(this.input);
            nli.encoding(this.encoding).validate(this.validate);
            return nli;
        }
        catch (IOException ex) {
            if (nli != null) {
                try {
                    nli.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            throw this.error.get(ii, ex);
        }
    }

    @Override
    public Item materialize(InputInfo ii) throws QueryException {
        return Str.get(this.string(ii));
    }

    @Override
    public String toString() {
        return Util.info(Function._FILE_READ_TEXT.args(this.input), new Object[0]);
    }
}

