/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryException;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class YMDur
extends Dur {
    private static final Pattern DUR = Pattern.compile("(-?)P((\\d+)Y)?((\\d+)M)?");

    public YMDur(Dur it) {
        super(AtomType.YMD);
        this.mon = it.mon;
        this.sec = BigDecimal.ZERO;
    }

    public YMDur(YMDur it, YMDur a, boolean p, InputInfo ii) throws QueryException {
        this(it);
        double d = (double)this.mon + (double)(p ? a.mon : -a.mon);
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw Err.MONTHRANGE.get(ii, d);
        }
        this.mon += p ? a.mon : -a.mon;
    }

    public YMDur(Dur it, double f, boolean m, InputInfo ii) throws QueryException {
        this(it);
        double d;
        if (Double.isNaN(f)) {
            throw Err.DATECALC.get(ii, this.description(), f);
        }
        if (m ? Double.isInfinite(f) : f == 0.0) {
            throw Err.DATEZERO.get(ii, this.type);
        }
        double d2 = d = m ? (double)this.mon * f : (double)this.mon / f;
        if (d <= -9.223372036854776E18 || d >= 9.223372036854776E18) {
            throw Err.MONTHRANGE.get(ii, d);
        }
        this.mon = StrictMath.round(d);
    }

    public YMDur(byte[] vl, InputInfo ii) throws QueryException {
        super(AtomType.YMD);
        String val = Token.string(vl).trim();
        Matcher mt = DUR.matcher(val);
        if (!mt.matches() || val.endsWith("P")) {
            throw this.dateError(vl, "P2000Y12M", ii);
        }
        this.yearMonth(vl, mt, ii);
        this.sec = BigDecimal.ZERO;
    }

    public long ymd() {
        return this.mon;
    }

    @Override
    public byte[] string(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        if (this.mon < 0L) {
            tb.add(45);
        }
        this.date(tb);
        if (this.mon == 0L) {
            tb.add("0M");
        }
        return tb.finish();
    }

    @Override
    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        if (it.type != this.type) {
            throw Err.diffError(ii, it, this);
        }
        long m = this.mon - ((Dur)it).mon;
        return m < 0L ? -1 : (m > 0L ? 1 : 0);
    }
}

