/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;

public final class BytSeq
extends NativeSeq {
    private final byte[] values;

    private BytSeq(byte[] vals) {
        super(vals.length, (Type)AtomType.BYT);
        this.values = vals;
    }

    @Override
    public Int itemAt(long pos) {
        return new Int(this.values[(int)pos], this.type);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof BytSeq && Token.eq(this.values, ((BytSeq)cmp).values);
    }

    public byte[] toJava() {
        return this.values;
    }

    @Override
    public Value reverse() {
        int s = this.values.length;
        byte[] tmp = new byte[s];
        int l = 0;
        int r = s - 1;
        while (l < s) {
            tmp[l] = this.values[r];
            ++l;
            --r;
        }
        return BytSeq.get(tmp);
    }

    public static Value get(byte[] items) {
        return items.length == 0 ? Empty.SEQ : (items.length == 1 ? Int.get(items[0], AtomType.BYT) : new BytSeq(items));
    }

    public static Value get(Value[] vals, int size) throws QueryException {
        byte[] tmp = new byte[size];
        int t = 0;
        for (Value val : vals) {
            int vs = (int)val.size();
            if (val instanceof Item) {
                tmp[t++] = (byte)((Item)val).itr(null);
                continue;
            }
            if (val instanceof BytSeq) {
                BytSeq sq = (BytSeq)val;
                System.arraycopy(sq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = (byte)val.itemAt(v).itr(null);
            }
        }
        return BytSeq.get(tmp);
    }
}

