/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.list.IntList;

public final class DBNodeSeq
extends NativeSeq {
    private final Data data;
    public final int[] pres;
    public final boolean complete;

    private DBNodeSeq(int[] p, Data d, Type t, boolean c) {
        super(p.length, t);
        this.pres = p;
        this.data = d;
        this.complete = c;
    }

    @Override
    public Data data() {
        return this.data;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) {
        return this.itemAt(0L);
    }

    @Override
    public boolean iterable() {
        return true;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof DBNodeSeq)) {
            return false;
        }
        DBNodeSeq seq = (DBNodeSeq)cmp;
        return this.pres == seq.pres && this.size == seq.size;
    }

    @Override
    public DBNode itemAt(long pos) {
        return new DBNode(this.data, this.pres[(int)pos]);
    }

    @Override
    public Value reverse() {
        int s = this.pres.length;
        int[] tmp = new int[s];
        int l = 0;
        int r = s - 1;
        while (l < s) {
            tmp[l] = this.pres[r];
            ++l;
            --r;
        }
        return DBNodeSeq.get(tmp, this.data, this.type, false);
    }

    public static Value get(IntList v, Data d, boolean docs, boolean c) {
        return DBNodeSeq.get(v.toArray(), d, docs ? NodeType.DOC : NodeType.NOD, c);
    }

    private static Value get(int[] v, Data d, Type t, boolean c) {
        return v.length == 0 ? Empty.SEQ : (v.length == 1 ? new DBNode(d, v[0]) : new DBNodeSeq(v, d, t, c));
    }
}

