/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Var
extends ExprInfo {
    private final StaticContext sc;
    public final QNm name;
    public final int id;
    public SeqType declType;
    int slot = -1;
    long size = -1L;
    private final boolean param;
    private SeqType inType;
    private boolean promote;

    Var(QueryContext ctx, StaticContext sctx, QNm n, SeqType typ, boolean fun) {
        this.sc = sctx;
        this.name = n;
        this.declType = typ == null || typ.eq(SeqType.ITEM_ZM) ? null : typ;
        this.inType = SeqType.ITEM_ZM;
        this.id = ctx.varIDs++;
        this.param = fun;
        this.promote = fun;
        this.size = this.inType.occ();
    }

    Var(QueryContext ctx, StaticContext sctx, Var var) {
        this(ctx, sctx, var.name, var.declType, var.param);
        this.promote = var.promote;
        this.inType = var.inType;
        this.size = var.size;
    }

    public SeqType type() {
        SeqType intersect;
        SeqType seqType = intersect = this.declType != null ? this.declType.intersect(this.inType) : null;
        return intersect != null ? intersect : (this.declType != null ? this.declType : this.inType);
    }

    public SeqType declaredType() {
        return this.declType == null ? SeqType.ITEM_ZM : this.declType;
    }

    public void refineType(SeqType t, QueryContext ctx, InputInfo ii) throws QueryException {
        SeqType is;
        if (t == null) {
            return;
        }
        if (this.declType != null) {
            if (this.declType.occ.intersect(t.occ) == null) {
                throw Err.INVCAST.get(ii, t, this.declType);
            }
            if (t.instanceOf(this.declType)) {
                ctx.compInfo("removing redundant % cast.", this);
                this.declType = null;
            } else if (!t.promotable(this.declType)) {
                return;
            }
        }
        if (!this.inType.eq(t) && !this.inType.instanceOf(t) && (is = this.inType.intersect(t)) != null) {
            this.inType = is;
        }
    }

    public boolean checksType() {
        return this.declType != null;
    }

    public Expr checked(Expr e, QueryContext ctx, VarScope scp, InputInfo ii) throws QueryException {
        return this.checksType() ? new TypeCheck(this.sc, ii, e, this.declType, this.promote).optimize(ctx, scp) : e;
    }

    public Value checkType(Value val, QueryContext ctx, InputInfo ii, boolean opt) throws QueryException {
        if (!this.checksType() || this.declType.instance(val)) {
            return val;
        }
        if (this.promote) {
            return this.declType.promote(ctx, this.sc, ii, val, opt);
        }
        throw Err.INVCAST.get(ii, val.type(), this.declType);
    }

    public void checkType(Expr expr, InputInfo info) throws QueryException {
        SeqType et = expr.type();
        SeqType vt = this.type();
        if (!this.checksType() || vt.type.instanceOf(et.type) || et.type.instanceOf(vt.type) && et.occ.instanceOf(vt.occ)) {
            return;
        }
        if (!this.promote || !et.type.isNode() && !et.promotable(vt)) {
            if (vt.type.nsSensitive() && this.sc.xquery3()) {
                throw Err.NSSENS.get(info, et, vt);
            }
            throw Err.INVCAST.get(info, et, vt);
        }
    }

    public boolean is(Var v) {
        return this.id == v.id;
    }

    public boolean promotes() {
        return this.promote;
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(QueryText.NAM, '$' + Token.string(this.name.string()), QueryText.ID, Token.token(this.id));
        if (this.declType != null) {
            e.add(this.planAttr("as", this.declType.toString()));
        }
        this.addPlan(plan, e, new ExprInfo[0]);
    }

    @Override
    public String toErrorString() {
        return new TokenBuilder().add("$").add(this.name.string()).toString();
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (this.name != null) {
            tb.add("$").add(this.name.string()).add(95).addInt(this.id);
            if (this.declType != null) {
                tb.add(" as");
            }
        }
        if (this.declType != null) {
            tb.add(" " + this.declType);
        }
        return tb.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof Var && this.is((Var)obj);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean adoptCheck(SeqType t, boolean prom) {
        if (this.declType == null || t.instanceOf(this.declType)) {
            this.declType = t;
        } else if (!this.declType.instanceOf(t)) {
            return false;
        }
        this.promote |= prom;
        return true;
    }
}

