/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import org.basex.core.Text;
import org.basex.core.parse.PasswordReader;
import org.basex.util.Prop;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class ConsoleReader {
    private static final String PW_PROMPT = Text.PASSWORD + ": ";
    private static final String PROMPT = "> ";
    private final PasswordReader pwReader = new PasswordReader(){

        @Override
        public String password() {
            return Token.md5(ConsoleReader.this.readPassword());
        }
    };

    public abstract String readLine();

    protected abstract String readPassword();

    public PasswordReader pwReader() {
        return this.pwReader;
    }

    public static ConsoleReader get() {
        if (JLineConsoleReader.isAvailable()) {
            try {
                return new JLineConsoleReader();
            }
            catch (Exception ex) {
                Util.errln(ex, new Object[0]);
            }
        }
        return new SimpleConsoleReader();
    }

    private static class JLineConsoleReader
    extends ConsoleReader {
        private static final String JLINE_CONSOLE_READER = "jline.ConsoleReader";
        private static final String JLINE_HISTORY = "jline.History";
        private static final String HISTORY_FILE = ".basexhistory";
        private static final Character PASSWORD_ECHO = Character.valueOf('\u0000');
        private final Class<?> readerClass = Reflect.find("jline.ConsoleReader");
        private final Method readLine = Reflect.method(this.readerClass, "readLine", new Class[0]);
        private final Method readEcho = Reflect.method(this.readerClass, "readLine", String.class, Character.class);
        private final Method setDefaultPrompt = Reflect.method(this.readerClass, "setDefaultPrompt", String.class);
        private final Object reader = this.readerClass.newInstance();

        static boolean isAvailable() {
            return Reflect.available(JLINE_CONSOLE_READER, new Object[0]);
        }

        JLineConsoleReader() throws Exception {
            this.defaultConfiguration();
        }

        private void defaultConfiguration() {
            Class<?> historyClass = Reflect.find(JLINE_HISTORY);
            File hist = new File(Prop.HOME, HISTORY_FILE);
            Object history = Reflect.get(Reflect.find(historyClass, File.class), hist);
            Reflect.invoke(Reflect.method(this.readerClass, "setUseHistory", Boolean.TYPE), this.reader, true);
            Reflect.invoke(Reflect.method(this.readerClass, "setBellEnabled", Boolean.TYPE), this.reader, false);
            Reflect.invoke(Reflect.method(this.readerClass, "setHistory", historyClass), this.reader, history);
            this.restoreDefaultPrompt();
        }

        private void restoreDefaultPrompt() {
            Reflect.invoke(this.setDefaultPrompt, this.reader, ConsoleReader.PROMPT);
        }

        @Override
        public String readLine() {
            return (String)Reflect.invoke(this.readLine, this.reader, new Object[0]);
        }

        @Override
        public String readPassword() {
            Object pw = Reflect.invoke(this.readEcho, this.reader, PW_PROMPT, PASSWORD_ECHO);
            this.restoreDefaultPrompt();
            return (String)pw;
        }
    }

    private static class SimpleConsoleReader
    extends ConsoleReader {
        private final BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

        SimpleConsoleReader() {
        }

        @Override
        public String readLine() {
            try {
                Util.out(ConsoleReader.PROMPT, new Object[0]);
                return this.in.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String readPassword() {
            Util.out(PW_PROMPT, new Object[0]);
            return Util.password();
        }
    }
}

